/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j;

import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.james.mime4j.BodyDescriptor;
import org.apache.james.mime4j.CloseShieldInputStream;
import org.apache.james.mime4j.ContentHandler;
import org.apache.james.mime4j.EOLConvertingInputStream;
import org.apache.james.mime4j.MimeBoundaryInputStream;
import org.apache.james.mime4j.RootInputStream;
import org.apache.james.mime4j.decoder.Base64InputStream;
import org.apache.james.mime4j.decoder.QuotedPrintableInputStream;

public class MimeStreamParser {
    private static final Log log;
    private static BitSet fieldChars;
    private RootInputStream rootStream = null;
    private LinkedList bodyDescriptors = new LinkedList();
    private ContentHandler handler = null;
    private boolean raw = false;

    public void parse(InputStream is) throws IOException {
        this.rootStream = new RootInputStream(is);
        this.parseMessage(this.rootStream);
    }

    public boolean isRaw() {
        return this.raw;
    }

    public void setRaw(boolean raw) {
        this.raw = raw;
    }

    public void stop() {
        this.rootStream.truncate();
    }

    private void parseEntity(InputStream is) throws IOException {
        BodyDescriptor bd = this.parseHeader(is);
        if (bd.isMultipart()) {
            this.bodyDescriptors.addFirst(bd);
            this.handler.startMultipart(bd);
            MimeBoundaryInputStream tempIs = new MimeBoundaryInputStream(is, bd.getBoundary());
            this.handler.preamble(new CloseShieldInputStream(tempIs));
            tempIs.consume();
            while (tempIs.hasMoreParts()) {
                tempIs = new MimeBoundaryInputStream(is, bd.getBoundary());
                this.parseBodyPart(tempIs);
                tempIs.consume();
                if (!tempIs.parentEOF()) continue;
                if (!log.isWarnEnabled()) break;
                log.warn((Object)("Line " + this.rootStream.getLineNumber() + ": Body part ended prematurely. " + "Higher level boundary detected or " + "EOF reached."));
                break;
            }
            this.handler.epilogue(new CloseShieldInputStream(is));
            this.handler.endMultipart();
            this.bodyDescriptors.removeFirst();
        } else if (bd.isMessage()) {
            if (bd.isBase64Encoded()) {
                log.warn((Object)"base64 encoded message/rfc822 detected");
                is = new EOLConvertingInputStream(new Base64InputStream(is));
            } else if (bd.isQuotedPrintableEncoded()) {
                log.warn((Object)"quoted-printable encoded message/rfc822 detected");
                is = new EOLConvertingInputStream(new QuotedPrintableInputStream(is));
            }
            this.bodyDescriptors.addFirst(bd);
            this.parseMessage(is);
            this.bodyDescriptors.removeFirst();
        } else {
            this.handler.body(bd, new CloseShieldInputStream(is));
        }
        while (is.read() != -1) {
        }
    }

    private void parseMessage(InputStream is) throws IOException {
        if (this.raw) {
            this.handler.raw(new CloseShieldInputStream(is));
        } else {
            this.handler.startMessage();
            this.parseEntity(is);
            this.handler.endMessage();
        }
    }

    private void parseBodyPart(InputStream is) throws IOException {
        if (this.raw) {
            this.handler.raw(new CloseShieldInputStream(is));
        } else {
            this.handler.startBodyPart();
            this.parseEntity(is);
            this.handler.endBodyPart();
        }
    }

    private BodyDescriptor parseHeader(InputStream is) throws IOException {
        BodyDescriptor bd = new BodyDescriptor(this.bodyDescriptors.isEmpty() ? null : (BodyDescriptor)this.bodyDescriptors.getFirst());
        this.handler.startHeader();
        int lineNumber = this.rootStream.getLineNumber();
        StringBuffer sb = new StringBuffer();
        int curr = 0;
        int prev = 0;
        while ((curr = is.read()) != -1) {
            if (curr == 10 && (prev == 10 || prev == 0)) {
                sb.deleteCharAt(sb.length() - 1);
                break;
            }
            sb.append((char)curr);
            prev = curr == 13 ? prev : curr;
        }
        if (curr == -1 && log.isWarnEnabled()) {
            log.warn((Object)("Line " + this.rootStream.getLineNumber() + ": Unexpected end of headers detected. " + "Boundary detected in header or EOF reached."));
        }
        int start = 0;
        int pos = 0;
        int startLineNumber = lineNumber;
        while (pos < sb.length()) {
            while (pos < sb.length() && sb.charAt(pos) != '\r') {
                ++pos;
            }
            if (pos < sb.length() - 1 && sb.charAt(pos + 1) != '\n') {
                ++pos;
                continue;
            }
            if (pos >= sb.length() - 2 || fieldChars.get(sb.charAt(pos + 2))) {
                String field = sb.substring(start, pos);
                start = pos + 2;
                int index = field.indexOf(58);
                boolean valid = false;
                if (index != -1 && fieldChars.get(field.charAt(0))) {
                    valid = true;
                    String fieldName = field.substring(0, index).trim();
                    for (int i = 0; i < fieldName.length(); ++i) {
                        if (fieldChars.get(fieldName.charAt(i))) continue;
                        valid = false;
                        break;
                    }
                    if (valid) {
                        this.handler.field(field);
                        bd.addField(fieldName, field.substring(index + 1));
                    }
                }
                if (!valid && log.isWarnEnabled()) {
                    log.warn((Object)("Line " + startLineNumber + ": Ignoring invalid field: '" + field.trim() + "'"));
                }
                startLineNumber = lineNumber;
            }
            pos += 2;
            ++lineNumber;
        }
        this.handler.endHeader();
        return bd;
    }

    public void setContentHandler(ContentHandler h) {
        this.handler = h;
    }

    static {
        int i;
        log = LogFactory.getLog((Class)MimeStreamParser.class);
        fieldChars = null;
        fieldChars = new BitSet();
        for (i = 33; i <= 57; ++i) {
            fieldChars.set(i);
        }
        for (i = 59; i <= 126; ++i) {
            fieldChars.set(i);
        }
    }
}

