/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.james.mime4j.AbstractContentHandler;
import org.apache.james.mime4j.MimeStreamParser;
import org.apache.james.mime4j.field.ContentTypeField;
import org.apache.james.mime4j.field.Field;
import org.apache.james.mime4j.util.CharsetUtil;

public class Header {
    private List fields = new LinkedList();
    private HashMap fieldMap = new HashMap();

    public Header() {
    }

    public Header(InputStream is) throws IOException {
        final MimeStreamParser parser = new MimeStreamParser();
        parser.setContentHandler(new AbstractContentHandler(){

            public void endHeader() {
                parser.stop();
            }

            public void field(String fieldData) {
                Header.this.addField(Field.parse(fieldData));
            }
        });
        parser.parse(is);
    }

    public void addField(Field field) {
        LinkedList<Field> values = (LinkedList<Field>)this.fieldMap.get(field.getName().toLowerCase());
        if (values == null) {
            values = new LinkedList<Field>();
            this.fieldMap.put(field.getName().toLowerCase(), values);
        }
        values.add(field);
        this.fields.add(field);
    }

    public List getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public Field getField(String name) {
        List l = (List)this.fieldMap.get(name.toLowerCase());
        if (l != null && !l.isEmpty()) {
            return (Field)l.get(0);
        }
        return null;
    }

    public List getFields(String name) {
        List l = (List)this.fieldMap.get(name.toLowerCase());
        return Collections.unmodifiableList(l);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        Iterator it = this.fields.iterator();
        while (it.hasNext()) {
            str.append(it.next().toString());
            str.append("\r\n");
        }
        return str.toString();
    }

    public void writeTo(OutputStream out) throws IOException {
        String charString = ((ContentTypeField)this.getField("Content-Type")).getCharset();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, CharsetUtil.getCharset(charString)), 8192);
        writer.write(this.toString() + "\r\n");
        writer.flush();
    }
}

