/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.util.JMeterUtils;

public class DebugPostProcessor
extends AbstractTestElement
implements PostProcessor,
TestBean {
    private static final long serialVersionUID = 260L;
    private boolean displaySamplerProperties;
    private boolean displayJMeterVariables;
    private boolean displayJMeterProperties;
    private boolean displaySystemProperties;

    public void process() {
        StringBuilder sb = new StringBuilder(100);
        StringBuilder rd = new StringBuilder(20);
        SampleResult sr = new SampleResult();
        sr.setSampleLabel(this.getName());
        sr.sampleStart();
        JMeterContext threadContext = this.getThreadContext();
        if (this.isDisplaySamplerProperties()) {
            rd.append("SamplerProperties\n");
            sb.append("SamplerProperties:\n");
            this.formatPropertyIterator(sb, threadContext.getCurrentSampler().propertyIterator());
            sb.append("\n");
        }
        if (this.isDisplayJMeterVariables()) {
            rd.append("JMeterVariables\n");
            sb.append("JMeterVariables:\n");
            this.formatSet(sb, threadContext.getVariables().entrySet());
            sb.append("\n");
        }
        if (this.isDisplayJMeterProperties()) {
            rd.append("JMeterProperties\n");
            sb.append("JMeterProperties:\n");
            this.formatSet(sb, JMeterUtils.getJMeterProperties().entrySet());
            sb.append("\n");
        }
        if (this.isDisplaySystemProperties()) {
            rd.append("SystemProperties\n");
            sb.append("SystemProperties:\n");
            this.formatSet(sb, System.getProperties().entrySet());
            sb.append("\n");
        }
        sr.setResponseData(sb.toString(), null);
        sr.setDataType("text");
        sr.setSamplerData(rd.toString());
        sr.setResponseOK();
        sr.sampleEnd();
        threadContext.getPreviousResult().addSubResult(sr);
    }

    private void formatPropertyIterator(StringBuilder sb, PropertyIterator iter) {
        HashMap<String, String> map = new HashMap<String, String>();
        while (iter.hasNext()) {
            JMeterProperty item = iter.next();
            map.put(item.getName(), item.getStringValue());
        }
        this.formatSet(sb, map.entrySet());
    }

    private void formatSet(StringBuilder sb, Set s) {
        ArrayList al = new ArrayList(s);
        al.sort((o1, o2) -> {
            String m1 = (String)o1.getKey();
            String m2 = (String)o2.getKey();
            return m1.compareTo(m2);
        });
        al.forEach(me -> sb.append(me.getKey()).append("=").append(me.getValue()).append("\n"));
    }

    public boolean isDisplayJMeterVariables() {
        return this.displayJMeterVariables;
    }

    public void setDisplayJMeterVariables(boolean displayJMeterVariables) {
        this.displayJMeterVariables = displayJMeterVariables;
    }

    public boolean isDisplayJMeterProperties() {
        return this.displayJMeterProperties;
    }

    public void setDisplayJMeterProperties(boolean displayJMeterPropterties) {
        this.displayJMeterProperties = displayJMeterPropterties;
    }

    public boolean isDisplaySamplerProperties() {
        return this.displaySamplerProperties;
    }

    public void setDisplaySamplerProperties(boolean displaySamplerProperties) {
        this.displaySamplerProperties = displaySamplerProperties;
    }

    public boolean isDisplaySystemProperties() {
        return this.displaySystemProperties;
    }

    public void setDisplaySystemProperties(boolean displaySystemProperties) {
        this.displaySystemProperties = displaySystemProperties;
    }
}

