/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers.poissonarrivals;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.timers.poissonarrivals.ConstantPoissonProcessGenerator;
import org.apache.jmeter.timers.poissonarrivals.DurationProvider;
import org.apache.jmeter.timers.poissonarrivals.EventProducer;
import org.apache.jmeter.timers.poissonarrivals.ThroughputProvider;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=3)
public class PreciseThroughputTimer
extends AbstractTestElement
implements Cloneable,
Timer,
TestStateListener,
TestBean,
ThroughputProvider,
DurationProvider {
    private static final Logger log = LoggerFactory.getLogger(PreciseThroughputTimer.class);
    private static final long serialVersionUID = 3L;
    private static final ConcurrentMap<AbstractThreadGroup, EventProducer> groupEvents = new ConcurrentHashMap<AbstractThreadGroup, EventProducer>();
    private double throughput;
    private int throughputPeriod;
    private long duration;
    private long testStarted;
    private int exactLimit;
    private double allowedThroughputSurplus;
    private Long randomSeed;
    private int batchSize;
    private int batchThreadDelay;

    public Object clone() {
        PreciseThroughputTimer newTimer = (PreciseThroughputTimer)super.clone();
        newTimer.testStarted = this.testStarted;
        return newTimer;
    }

    public void testStarted() {
        this.testStarted(null);
    }

    public void testStarted(String host) {
        groupEvents.clear();
        this.testStarted = System.currentTimeMillis();
    }

    public void testEnded() {
    }

    public void testEnded(String s) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delay() {
        double nextEvent;
        EventProducer events;
        EventProducer eventProducer = events = this.getEventProducer();
        synchronized (eventProducer) {
            nextEvent = events.next();
        }
        long delay = (long)(nextEvent * (double)TimeUnit.SECONDS.toMillis(1L) + (double)this.testStarted - (double)System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug("Calculated delay is {}", (Object)delay);
        }
        delay = Math.max(0L, delay);
        long endTime = this.getThreadContext().getThread().getEndTime();
        if (endTime > 0L && System.currentTimeMillis() + delay > endTime) {
            throw new JMeterStopThreadException("The thread is scheduled to stop in " + (System.currentTimeMillis() - endTime) + " ms and the throughput timer generates a delay of " + delay + ". JMeter (as of 4.0) does not support interrupting of sleeping threads, thus terminating the thread manually.");
        }
        return delay;
    }

    private EventProducer getEventProducer() {
        AbstractThreadGroup tg = this.getThreadContext().getThreadGroup();
        Long seed = this.randomSeed == null || this.randomSeed == 0L ? null : this.randomSeed;
        return groupEvents.computeIfAbsent(tg, x -> new ConstantPoissonProcessGenerator(() -> this.getThroughput() / (double)this.throughputPeriod, this.batchSize, this.batchThreadDelay, this, this.exactLimit, this.allowedThroughputSurplus, seed, true));
    }

    @Override
    public double getThroughput() {
        return this.throughput;
    }

    public void setThroughput(double throughput) {
        this.throughput = throughput;
    }

    public int getThroughputPeriod() {
        return this.throughputPeriod;
    }

    public void setThroughputPeriod(int throughputPeriod) {
        this.throughputPeriod = throughputPeriod;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public int getExactLimit() {
        return this.exactLimit;
    }

    public void setExactLimit(int exactLimit) {
        this.exactLimit = exactLimit;
    }

    public double getAllowedThroughputSurplus() {
        return this.allowedThroughputSurplus;
    }

    public void setAllowedThroughputSurplus(double allowedThroughputSurplus) {
        this.allowedThroughputSurplus = allowedThroughputSurplus;
    }

    public Long getRandomSeed() {
        return this.randomSeed;
    }

    public void setRandomSeed(Long randomSeed) {
        this.randomSeed = randomSeed;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchThreadDelay() {
        return this.batchThreadDelay;
    }

    public void setBatchThreadDelay(int batchThreadDelay) {
        this.batchThreadDelay = batchThreadDelay;
    }
}

