/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.proxy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.jmeter.protocol.http.proxy.HttpRequestHdr;
import org.apache.jmeter.protocol.http.proxy.SamplerCreator;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public abstract class AbstractSamplerCreator
implements SamplerCreator {
    protected static final String HTTP = "http";
    protected static final String HTTPS = "https";
    private static final String BINARY_FILE_SUFFIX = JMeterUtils.getPropDefault((String)"proxy.binary.filesuffix", (String)".binary");
    private static final Set<String> BINARY_CONTENT_TYPES = new HashSet<String>();
    private static final String BINARY_DIRECTORY = JMeterUtils.getPropDefault((String)"proxy.binary.directory", (String)System.getProperty("user.dir"));
    private static final boolean NUMBER_REQUESTS = JMeterUtils.getPropDefault((String)"proxy.number.requests", (boolean)true);
    private static AtomicInteger REQUEST_NUMBER = new AtomicInteger(0);

    protected static int getRequestNumber() {
        return REQUEST_NUMBER.get();
    }

    protected static void incrementRequestNumber() {
        AbstractSamplerCreator.incrementRequestNumberAndGet();
    }

    protected static int incrementRequestNumberAndGet() {
        return REQUEST_NUMBER.incrementAndGet();
    }

    protected static boolean isNumberRequests() {
        return NUMBER_REQUESTS;
    }

    protected boolean isBinaryContent(String contentType) {
        if (contentType == null) {
            return false;
        }
        return BINARY_CONTENT_TYPES.contains(contentType);
    }

    protected String getBinaryFileSuffix() {
        return BINARY_FILE_SUFFIX;
    }

    protected String getBinaryDirectory() {
        return BINARY_DIRECTORY;
    }

    @Override
    public void postProcessSampler(HTTPSamplerBase sampler, SampleResult result) {
    }

    @Override
    public HTTPSamplerBase createAndPopulateSampler(HttpRequestHdr request, Map<String, String> pageEncodings, Map<String, String> formEncodings) throws Exception {
        HTTPSamplerBase sampler = this.createSampler(request, pageEncodings, formEncodings);
        this.populateSampler(sampler, request, pageEncodings, formEncodings);
        return sampler;
    }

    @Override
    public List<TestElement> createChildren(HTTPSamplerBase sampler, SampleResult result) {
        return Collections.emptyList();
    }

    static {
        String binaries = JMeterUtils.getPropDefault((String)"proxy.binary.types", (String)"application/x-amf,application/x-java-serialized-object");
        if (binaries.length() > 0) {
            StringTokenizer s = new StringTokenizer(binaries, "|, ");
            while (s.hasMoreTokens()) {
                BINARY_CONTENT_TYPES.add(s.nextToken());
            }
        }
    }
}

