/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.jorphan.gui.ObjectTableModel;

public class ObjectTableSorter
extends RowSorter<ObjectTableModel> {
    private ObjectTableModel model;
    private RowSorter.SortKey sortkey;
    private Comparator<Row> comparator = null;
    private ArrayList<Row> viewToModel = new ArrayList();
    private int[] modelToView = new int[0];
    private Comparator<Row> primaryComparator = null;
    private Comparator<?>[] valueComparators;
    private Comparator<Row> fallbackComparator;

    public ObjectTableSorter(ObjectTableModel model) {
        this.model = model;
        this.valueComparators = new Comparator[this.model.getColumnCount()];
        for (int i = 0; i < this.valueComparators.length; ++i) {
            this.setValueComparator(i, null);
        }
        this.setFallbackComparator(null);
    }

    public Comparator<Row> getPrimaryComparator() {
        return this.primaryComparator;
    }

    public Comparator<?> getValueComparator(int column) {
        return this.valueComparators[column];
    }

    public Comparator<Row> getFallbackComparator() {
        return this.fallbackComparator;
    }

    public ObjectTableSorter setPrimaryComparator(Comparator<Row> primaryComparator) {
        this.invalidate();
        this.primaryComparator = primaryComparator;
        return this;
    }

    public ObjectTableSorter fixLastRow() {
        return this.setPrimaryComparator(new PreserveLastRowComparator());
    }

    public ObjectTableSorter setValueComparator(int column, Comparator<?> comparator) {
        this.invalidate();
        this.valueComparators[column] = (Comparator)ObjectUtils.defaultIfNull(comparator, this.getDefaultComparator(column));
        return this;
    }

    protected Comparator<?> getDefaultComparator(int column) {
        Class<?> columnClass = this.model.getColumnClass(column);
        if (columnClass == null) {
            return null;
        }
        if (columnClass == String.class) {
            return Comparator.nullsFirst(Collator.getInstance());
        }
        if (Comparable.class.isAssignableFrom(columnClass)) {
            return Comparator.nullsFirst(Comparator.naturalOrder());
        }
        return null;
    }

    public ObjectTableSorter setFallbackComparator(Comparator<Row> comparator) {
        this.invalidate();
        this.fallbackComparator = (Comparator)ObjectUtils.defaultIfNull(comparator, Comparator.comparingInt(Row::getIndex));
        return this;
    }

    @Override
    public ObjectTableModel getModel() {
        return this.model;
    }

    @Override
    public void toggleSortOrder(int column) {
        RowSorter.SortKey newSortKey;
        if (this.isSortable(column)) {
            SortOrder newOrder = this.sortkey == null || this.sortkey.getColumn() != column || this.sortkey.getSortOrder() != SortOrder.ASCENDING ? SortOrder.ASCENDING : SortOrder.DESCENDING;
            newSortKey = new RowSorter.SortKey(column, newOrder);
        } else {
            newSortKey = null;
        }
        this.setSortKey(newSortKey);
    }

    @Override
    public int convertRowIndexToModel(int index) {
        if (!this.isSorted()) {
            return index;
        }
        this.validate();
        return this.viewToModel.get(index).getIndex();
    }

    @Override
    public int convertRowIndexToView(int index) {
        if (!this.isSorted()) {
            return index;
        }
        this.validate();
        return this.modelToView[index];
    }

    @Override
    public void setSortKeys(List<? extends RowSorter.SortKey> keys) {
        switch (keys.size()) {
            case 0: {
                this.setSortKey(null);
                break;
            }
            case 1: {
                this.setSortKey(keys.get(0));
                break;
            }
            default: {
                throw new IllegalArgumentException("Only one column can be sorted");
            }
        }
    }

    public void setSortKey(RowSorter.SortKey sortkey) {
        int column;
        if (Objects.equals(this.sortkey, sortkey)) {
            return;
        }
        this.invalidate();
        if (sortkey != null && this.valueComparators[column = sortkey.getColumn()] == null) {
            throw new IllegalArgumentException(String.format("Can't sort column %s, it is mapped to type %s and this one have no natural order. So an explicit one must be specified", column, this.model.getColumnClass(column)));
        }
        this.sortkey = sortkey;
        this.comparator = null;
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.isSorted() ? Collections.singletonList(this.sortkey) : Collections.emptyList();
    }

    @Override
    public int getViewRowCount() {
        return this.getModelRowCount();
    }

    @Override
    public int getModelRowCount() {
        return this.model.getRowCount();
    }

    @Override
    public void modelStructureChanged() {
        this.setSortKey(null);
    }

    @Override
    public void allRowsChanged() {
        this.invalidate();
    }

    @Override
    public void rowsInserted(int firstRow, int endRow) {
        this.rowsChanged(firstRow, endRow, false, true);
    }

    @Override
    public void rowsDeleted(int firstRow, int endRow) {
        this.rowsChanged(firstRow, endRow, true, false);
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow) {
        this.rowsChanged(firstRow, endRow, true, true);
    }

    protected void rowsChanged(int firstRow, int endRow, boolean deleted, boolean inserted) {
        this.invalidate();
    }

    @Override
    public void rowsUpdated(int firstRow, int endRow, int column) {
        if (this.isSorted(column)) {
            this.rowsUpdated(firstRow, endRow);
        }
    }

    protected boolean isSortable(int column) {
        return this.getValueComparator(column) != null;
    }

    protected boolean isSorted(int column) {
        return this.isSorted() && this.sortkey.getColumn() == column && this.sortkey.getSortOrder() != SortOrder.UNSORTED;
    }

    protected boolean isSorted() {
        return this.sortkey != null;
    }

    protected void invalidate() {
        this.viewToModel.clear();
        this.modelToView = new int[0];
    }

    protected void validate() {
        if (this.isSorted() && this.viewToModel.isEmpty()) {
            this.sort();
        }
    }

    protected Comparator<Row> getComparatorFromSortKey(RowSorter.SortKey sortkey) {
        Comparator<?> comp = this.getValueComparator(sortkey.getColumn());
        if (sortkey.getSortOrder() == SortOrder.DESCENDING) {
            comp = comp.reversed();
        }
        Function<Row, Object> getValueAt = row -> row.getValueAt(sortkey.getColumn());
        return Comparator.comparing(getValueAt, comp);
    }

    protected void sort() {
        if (this.comparator == null) {
            this.comparator = Stream.concat(Stream.concat(this.getPrimaryComparator() != null ? Stream.of(this.getPrimaryComparator()) : Stream.empty(), this.getSortKeys().stream().filter(sk -> sk != null && sk.getSortOrder() != SortOrder.UNSORTED).map(this::getComparatorFromSortKey)), Stream.of(this.getFallbackComparator())).reduce(this.comparator, (result, current) -> result != null ? result.thenComparing(current) : current);
        }
        this.viewToModel.clear();
        int rowCount = this.model.getRowCount();
        this.viewToModel.ensureCapacity(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.viewToModel.add(new Row(i));
        }
        Collections.sort(this.viewToModel, this.comparator);
        this.updateModelToView();
    }

    protected void updateModelToView() {
        this.modelToView = new int[this.viewToModel.size()];
        for (int i = 0; i < this.viewToModel.size(); ++i) {
            this.modelToView[this.viewToModel.get((int)i).getIndex()] = i;
        }
    }

    protected class PreserveLastRowComparator
    implements Comparator<Row> {
        protected PreserveLastRowComparator() {
        }

        @Override
        public int compare(Row o1, Row o2) {
            int lastIndex = ObjectTableSorter.this.model.getRowCount() - 1;
            if (o1.getIndex() >= lastIndex || o2.getIndex() >= lastIndex) {
                return o1.getIndex() - o2.getIndex();
            }
            return 0;
        }
    }

    public class Row {
        private int index;

        protected Row(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getValue() {
            return ObjectTableSorter.this.getModel().getObjectListAsList().get(this.getIndex());
        }

        public Object getValueAt(int column) {
            return ObjectTableSorter.this.getModel().getValueAt(this.getIndex(), column);
        }
    }
}

