/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.binder.cache;

import java.util.concurrent.TimeUnit;
import org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionCounter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionTimer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Gauge;
import org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Tag;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Tags;
import org.apache.kudu.shaded.io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import org.apache.kudu.shaded.io.micrometer.core.instrument.binder.cache.HazelcastIMapAdapter;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullApi;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullFields;
import org.apache.kudu.shaded.io.micrometer.core.lang.Nullable;

@NonNullApi
@NonNullFields
public class HazelcastCacheMetrics
extends CacheMeterBinder {
    private final HazelcastIMapAdapter cache;

    public static Object monitor(MeterRegistry registry, Object cache, String ... tags) {
        return HazelcastCacheMetrics.monitor(registry, cache, Tags.of(tags));
    }

    public static Object monitor(MeterRegistry registry, Object cache, Iterable<Tag> tags) {
        new HazelcastCacheMetrics(cache, tags).bindTo(registry);
        return cache;
    }

    public HazelcastCacheMetrics(Object cache, Iterable<Tag> tags) {
        super(cache, HazelcastIMapAdapter.nameOf(cache), tags);
        this.cache = new HazelcastIMapAdapter(cache);
    }

    @Override
    protected Long size() {
        return this.cache.getLocalMapStats().getOwnedEntryCount();
    }

    @Override
    protected long hitCount() {
        return this.cache.getLocalMapStats().getHits();
    }

    @Override
    protected Long missCount() {
        return null;
    }

    @Override
    @Nullable
    protected Long evictionCount() {
        return null;
    }

    @Override
    protected long putCount() {
        return this.cache.getLocalMapStats().getPutOperationCount();
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        Gauge.builder("cache.entries", this.cache, cache -> cache.getLocalMapStats().getBackupEntryCount()).tags(this.getTagsWithCacheName()).tag("ownership", "backup").description("The number of backup entries held by this member").register(registry);
        Gauge.builder("cache.entries", this.cache, cache -> cache.getLocalMapStats().getOwnedEntryCount()).tags(this.getTagsWithCacheName()).tag("ownership", "owned").description("The number of owned entries held by this member").register(registry);
        Gauge.builder("cache.entry.memory", this.cache, cache -> cache.getLocalMapStats().getBackupEntryMemoryCost()).tags(this.getTagsWithCacheName()).tag("ownership", "backup").description("Memory cost of backup entries held by this member").baseUnit("bytes").register(registry);
        Gauge.builder("cache.entry.memory", this.cache, cache -> cache.getLocalMapStats().getOwnedEntryMemoryCost()).tags(this.getTagsWithCacheName()).tag("ownership", "owned").description("Memory cost of owned entries held by this member").baseUnit("bytes").register(registry);
        FunctionCounter.builder("cache.partition.gets", this.cache, cache -> cache.getLocalMapStats().getGetOperationCount()).tags(this.getTagsWithCacheName()).description("The total number of get operations executed against this partition").register(registry);
        this.timings(registry);
        this.nearCacheMetrics(registry);
    }

    private void nearCacheMetrics(MeterRegistry registry) {
        if (this.cache.getLocalMapStats().getNearCacheStats() != null) {
            Gauge.builder("cache.near.requests", this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getHits()).tags(this.getTagsWithCacheName()).tag("result", "hit").description("The number of hits (reads) of near cache entries owned by this member").register(registry);
            Gauge.builder("cache.near.requests", this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getMisses()).tags(this.getTagsWithCacheName()).tag("result", "miss").description("The number of hits (reads) of near cache entries owned by this member").register(registry);
            Gauge.builder("cache.near.evictions", this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getEvictions()).tags(this.getTagsWithCacheName()).description("The number of evictions of near cache entries owned by this member").register(registry);
            Gauge.builder("cache.near.persistences", this.cache, cache -> cache.getLocalMapStats().getNearCacheStats().getPersistenceCount()).tags(this.getTagsWithCacheName()).description("The number of Near Cache key persistences (when the pre-load feature is enabled)").register(registry);
        }
    }

    private void timings(MeterRegistry registry) {
        FunctionTimer.builder("cache.gets.latency", this.cache, cache -> cache.getLocalMapStats().getGetOperationCount(), cache -> cache.getLocalMapStats().getTotalGetLatency(), TimeUnit.MILLISECONDS).tags(this.getTagsWithCacheName()).description("Cache gets").register(registry);
        FunctionTimer.builder("cache.puts.latency", this.cache, cache -> cache.getLocalMapStats().getPutOperationCount(), cache -> cache.getLocalMapStats().getTotalPutLatency(), TimeUnit.MILLISECONDS).tags(this.getTagsWithCacheName()).description("Cache puts").register(registry);
        FunctionTimer.builder("cache.removals.latency", this.cache, cache -> cache.getLocalMapStats().getRemoveOperationCount(), cache -> cache.getLocalMapStats().getTotalRemoveLatency(), TimeUnit.MILLISECONDS).tags(this.getTagsWithCacheName()).description("Cache removals").register(registry);
    }
}

