/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.junit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashSet;
import org.apache.logging.log4j.test.junit.AbstractFileCleaner;
import org.apache.logging.log4j.test.junit.CleanUpDirectories;
import org.junit.jupiter.api.extension.ExtensionContext;

class DirectoryCleaner
extends AbstractFileCleaner {
    DirectoryCleaner() {
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    Collection<Path> getPathsForTest(ExtensionContext context) {
        CleanUpDirectories testMethodAnnotation;
        HashSet<Path> paths = new HashSet<Path>();
        CleanUpDirectories testClassAnnotation = context.getRequiredTestClass().getAnnotation(CleanUpDirectories.class);
        if (testClassAnnotation != null) {
            for (String path : testClassAnnotation.value()) {
                paths.add(Paths.get(path, new String[0]));
            }
        }
        if ((testMethodAnnotation = context.getRequiredTestMethod().getAnnotation(CleanUpDirectories.class)) != null) {
            for (String path : testMethodAnnotation.value()) {
                paths.add(Paths.get(path, new String[0]));
            }
        }
        return paths;
    }

    @Override
    boolean delete(Path path) throws IOException {
        return DirectoryCleaner.deleteDirectory(path);
    }

    static boolean deleteDirectory(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.deleteIfExists(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.deleteIfExists(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return true;
    }
}

