/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.docrenderer.DocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.io.xpp3.DocumentXpp3Reader;
import org.apache.maven.doxia.logging.Log;
import org.apache.maven.doxia.logging.PlexusLoggerWrapper;
import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.module.site.manager.SiteModuleManager;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.SiteResourceLoader;
import org.codehaus.plexus.velocity.VelocityComponent;

public abstract class AbstractDocumentRenderer
extends AbstractLogEnabled
implements DocumentRenderer {
    protected SiteModuleManager siteModuleManager;
    protected Doxia doxia;
    private VelocityComponent velocity;
    private String baseDir;

    public abstract void render(Map var1, File var2, DocumentModel var3) throws DocumentRendererException, IOException;

    public void render(Collection files, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        this.render(this.getFilesToProcess(files), outputDirectory, documentModel, null);
    }

    public void render(File baseDirectory, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        this.render(baseDirectory, outputDirectory, documentModel, null);
    }

    public void render(Map filesToProcess, File outputDirectory, DocumentModel documentModel, DocumentRendererContext context) throws DocumentRendererException, IOException {
    }

    public void render(File baseDirectory, File outputDirectory, DocumentModel documentModel, DocumentRendererContext context) throws DocumentRendererException, IOException {
        this.render(this.getFilesToProcess(baseDirectory), outputDirectory, documentModel, context);
    }

    public void render(File baseDirectory, File outputDirectory) throws DocumentRendererException, IOException {
        this.render(baseDirectory, outputDirectory, (DocumentModel)null);
    }

    public void render(File baseDirectory, File outputDirectory, File documentDescriptor) throws DocumentRendererException, IOException {
        if (documentDescriptor == null || !documentDescriptor.exists()) {
            this.getLogger().warn("No documentDescriptor found: using default settings!");
            this.render(baseDirectory, outputDirectory);
        } else {
            this.render(this.getFilesToProcess(baseDirectory), outputDirectory, this.readDocumentModel(documentDescriptor), null);
        }
    }

    public void renderIndividual(Map filesToProcess, File outputDirectory) throws DocumentRendererException, IOException {
    }

    public void renderIndividual(Map filesToProcess, File outputDirectory, DocumentRendererContext context) throws DocumentRendererException, IOException {
    }

    public Map getFilesToProcess(File baseDirectory) throws IOException, DocumentRendererException {
        if (!baseDirectory.isDirectory()) {
            this.getLogger().warn("No files found to process!");
            return new HashMap();
        }
        this.setBaseDir(baseDirectory.getAbsolutePath());
        LinkedHashMap<String, SiteModule> filesToProcess = new LinkedHashMap<String, SiteModule>();
        LinkedHashMap<String, String> duplicatesFiles = new LinkedHashMap<String, String>();
        Iterator i = this.siteModuleManager.getSiteModules().iterator();
        while (i.hasNext()) {
            SiteModule module = (SiteModule)i.next();
            File moduleBasedir = new File(baseDirectory, module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            List allFiles = FileUtils.getFileNames((File)moduleBasedir, (String)"**/*.*", null, (boolean)false);
            String lowerCaseExtension = module.getExtension().toLowerCase(Locale.ENGLISH);
            LinkedList docs = new LinkedList(allFiles);
            Iterator it = docs.iterator();
            while (it.hasNext()) {
                String name = it.next().toString().trim();
                if (name.toLowerCase(Locale.ENGLISH).endsWith("." + lowerCaseExtension)) continue;
                it.remove();
            }
            LinkedList velocityFiles = new LinkedList(allFiles);
            Iterator it2 = velocityFiles.iterator();
            while (it2.hasNext()) {
                String name = it2.next().toString().trim();
                if (name.toLowerCase(Locale.ENGLISH).endsWith(lowerCaseExtension + ".vm")) continue;
                it2.remove();
            }
            docs.addAll(velocityFiles);
            Iterator j = docs.iterator();
            while (j.hasNext()) {
                String filePath = j.next().toString().trim();
                if (filePath.lastIndexOf(".") > 0) {
                    String key = filePath.substring(0, filePath.lastIndexOf("."));
                    if (duplicatesFiles.containsKey(key)) {
                        throw new DocumentRendererException("Files '" + module.getSourceDirectory() + File.separator + filePath + "' clashes with existing '" + duplicatesFiles.get(key) + "'.");
                    }
                    duplicatesFiles.put(key, module.getSourceDirectory() + File.separator + filePath);
                }
                filesToProcess.put(filePath, module);
            }
        }
        return filesToProcess;
    }

    public Map getFilesToProcess(Collection files) {
        HashMap<String, SiteModule> filesToProcess = new HashMap<String, SiteModule>();
        Iterator it = this.siteModuleManager.getSiteModules().iterator();
        while (it.hasNext()) {
            SiteModule siteModule = (SiteModule)it.next();
            String extension = "." + siteModule.getExtension();
            String sourceDirectory = File.separator + siteModule.getSourceDirectory() + File.separator;
            Iterator j = files.iterator();
            while (j.hasNext()) {
                String file = (String)j.next();
                if (file.indexOf(sourceDirectory) != -1) {
                    filesToProcess.put(file, siteModule);
                    continue;
                }
                if (!file.toLowerCase(Locale.ENGLISH).endsWith(extension) || filesToProcess.containsKey(file)) continue;
                filesToProcess.put(file, siteModule);
            }
        }
        return filesToProcess;
    }

    public DocumentModel readDocumentModel(File documentDescriptor) throws DocumentRendererException, IOException {
        DocumentModel documentModel;
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)documentDescriptor);
            documentModel = new DocumentXpp3Reader().read((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new DocumentRendererException("Error parsing document descriptor", e);
        }
        finally {
            IOUtil.close((Reader)reader);
        }
        return documentModel;
    }

    public void setBaseDir(String newDir) {
        this.baseDir = newDir;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    protected void parse(String fullDocPath, String parserId, Sink sink) throws DocumentRendererException, IOException {
        this.parse(fullDocPath, parserId, sink, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parse(String fullDocPath, String parserId, Sink sink, DocumentRendererContext context) throws DocumentRendererException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Parsing file " + fullDocPath);
        }
        Object reader = null;
        try {
            File f = new File(fullDocPath);
            Parser parser = this.doxia.getParser(parserId);
            switch (parser.getType()) {
                case 2: {
                    reader = ReaderFactory.newXmlReader((File)f);
                    if (!AbstractDocumentRenderer.isVelocityFile(f)) break;
                    reader = this.getVelocityReader(f, reader.getEncoding(), context);
                    break;
                }
                default: {
                    reader = AbstractDocumentRenderer.isVelocityFile(f) ? this.getVelocityReader(f, context == null ? ReaderFactory.FILE_ENCODING : context.getInputEncoding(), context) : (context == null ? ReaderFactory.newPlatformReader((File)f) : ReaderFactory.newReader((File)f, (String)context.getInputEncoding()));
                }
            }
            sink.enableLogging((Log)new PlexusLoggerWrapper(this.getLogger()));
            this.doxia.parse((Reader)reader, parserId, sink);
        }
        catch (ParserNotFoundException e) {
            try {
                throw new DocumentRendererException("No parser '" + parserId + "' found for " + fullDocPath + ": " + e.getMessage());
                catch (ParseException e2) {
                    throw new DocumentRendererException("Error parsing " + fullDocPath + ": " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                sink.flush();
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        sink.flush();
    }

    protected void copyResources(File outputDirectory) throws IOException {
        File resourcesDirectory = new File(this.getBaseDir(), "resources");
        if (!resourcesDirectory.isDirectory()) {
            return;
        }
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        this.copyDirectory(resourcesDirectory, outputDirectory);
    }

    protected void copyDirectory(File source, File destination) throws IOException {
        if (source.isDirectory() && destination.isDirectory()) {
            DirectoryScanner scanner = new DirectoryScanner();
            String[] includedResources = new String[]{"**/**"};
            scanner.setIncludes(includedResources);
            scanner.addDefaultExcludes();
            scanner.setBasedir(source);
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            Iterator<String> j = includedFiles.iterator();
            while (j.hasNext()) {
                String name = j.next();
                File sourceFile = new File(source, name);
                File destinationFile = new File(destination, name);
                FileUtils.copyFile((File)sourceFile, (File)destinationFile);
            }
        }
    }

    protected String getOutputName(DocumentModel documentModel) {
        String outputName = documentModel.getOutputName();
        if (outputName == null) {
            this.getLogger().info("No outputName is defined in the document descriptor. Using 'target'");
            documentModel.setOutputName("target");
        }
        if ((outputName = outputName.trim()).toLowerCase(Locale.ENGLISH).endsWith("." + this.getOutputExtension())) {
            outputName = outputName.substring(0, outputName.toLowerCase(Locale.ENGLISH).lastIndexOf("." + this.getOutputExtension()));
        }
        documentModel.setOutputName(outputName);
        return documentModel.getOutputName();
    }

    private Reader getVelocityReader(File f, String encoding, DocumentRendererContext context) throws DocumentRendererException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Velocity render for " + f.getAbsolutePath());
        }
        SiteResourceLoader.setResource((String)f.getAbsolutePath());
        VelocityContext velocityContext = new VelocityContext();
        if (context.getKeys() != null) {
            for (int i = 0; i < context.getKeys().length; ++i) {
                String key = (String)context.getKeys()[i];
                velocityContext.put(key, context.get(key));
            }
        }
        StringWriter sw = new StringWriter();
        try {
            this.velocity.getEngine().mergeTemplate(f.getAbsolutePath(), encoding, (Context)velocityContext, (Writer)sw);
        }
        catch (Exception e) {
            throw new DocumentRendererException("Error whenn parsing Velocity file " + f.getAbsolutePath() + ": " + e.getMessage(), e);
        }
        return new StringReader(sw.toString());
    }

    private static boolean isVelocityFile(File f) {
        return FileUtils.getExtension((String)f.getAbsolutePath()).toLowerCase(Locale.ENGLISH).endsWith("vm");
    }
}

