/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer.itext;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.itext.AbstractITextRender;
import org.apache.maven.doxia.docrenderer.itext.RtfRenderer;
import org.apache.maven.doxia.module.itext.ITextUtil;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=RtfRenderer.class, hint="itext.rtf")
public class DefaultRtfRenderer
extends AbstractITextRender
implements RtfRenderer {
    @Override
    public String getOutputExtension() {
        return "rtf";
    }

    @Override
    public void generateOutput(File iTextFile, File iTextOutput) throws DocumentRendererException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Writing : " + iTextOutput);
        }
        try {
            ITextUtil.writeRtf((InputStream)new FileInputStream(iTextFile), (OutputStream)new FileOutputStream(iTextOutput));
        }
        catch (RuntimeException e) {
            throw new DocumentRendererException("Error writing RTF from " + iTextOutput + ": " + e.getMessage());
        }
    }
}

