/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.SessionScoped;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.ChainedListener;
import org.apache.maven.buildcache.xml.Build;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named
public class LifecyclePhasesHelper
extends AbstractExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecyclePhasesHelper.class);
    private final MavenSession session;
    private final DefaultLifecycles defaultLifecycles;
    private final List<String> phases;
    private final String lastCleanPhase;
    private final ConcurrentMap<MavenProject, MojoExecution> forkedProjectToOrigin = new ConcurrentHashMap<MavenProject, MojoExecution>();

    @Inject
    public LifecyclePhasesHelper(MavenSession session, DefaultLifecycles defaultLifecycles, @Named(value="clean") Lifecycle cleanLifecycle) {
        this.session = session;
        this.defaultLifecycles = Objects.requireNonNull(defaultLifecycles);
        this.phases = defaultLifecycles.getLifeCycles().stream().flatMap(lf -> lf.getPhases().stream()).collect(Collectors.toList());
        this.lastCleanPhase = (String)CacheUtils.getLast(cleanLifecycle.getPhases());
    }

    @PostConstruct
    public void init() {
        MavenExecutionRequest request = this.session.getRequest();
        ChainedListener lifecycleListener = new ChainedListener(request.getExecutionListener());
        lifecycleListener.chainListener((ExecutionListener)this);
        request.setExecutionListener((ExecutionListener)lifecycleListener);
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        LOGGER.debug("Started forked project. Project: {}, instance: {}, originating mojo: {}", new Object[]{event.getProject(), System.identityHashCode(event.getProject()), event.getMojoExecution()});
        this.forkedProjectToOrigin.put(event.getProject(), event.getMojoExecution());
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        LOGGER.debug("Finished forked project. Project: {}, instance: {}", (Object)event.getProject(), (Object)System.identityHashCode(event.getProject()));
        this.forkedProjectToOrigin.remove(event.getProject(), event.getMojoExecution());
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        LOGGER.debug("Finished forked project. Project: {}, instance: {}", (Object)event.getProject(), (Object)System.identityHashCode(event.getProject()));
        this.forkedProjectToOrigin.remove(event.getProject(), event.getMojoExecution());
    }

    @Nonnull
    public String resolveHighestLifecyclePhase(MavenProject project, List<MojoExecution> mojoExecutions) {
        return this.resolveMojoExecutionLifecyclePhase(project, CacheUtils.getLast(mojoExecutions));
    }

    public boolean isLaterPhaseThanClean(String phase) {
        return this.isLaterPhase(phase, this.lastCleanPhase);
    }

    public boolean isLaterPhaseThanBuild(String phase, Build build) {
        return this.isLaterPhase(phase, build.getHighestCompletedGoal());
    }

    public boolean isLaterPhase(String phase, String other) {
        if (!this.phases.contains(phase)) {
            throw new IllegalArgumentException("Unsupported phase: " + phase);
        }
        if (!this.phases.contains(other)) {
            throw new IllegalArgumentException("Unsupported phase: " + other);
        }
        return this.phases.indexOf(phase) > this.phases.indexOf(other);
    }

    public List<MojoExecution> getCleanSegment(MavenProject project, List<MojoExecution> mojoExecutions) {
        MojoExecution mojoExecution;
        String lifecyclePhase;
        ArrayList<MojoExecution> list = new ArrayList<MojoExecution>(mojoExecutions.size());
        Iterator<MojoExecution> iterator = mojoExecutions.iterator();
        while (iterator.hasNext() && !this.isLaterPhaseThanClean(lifecyclePhase = this.resolveMojoExecutionLifecyclePhase(project, mojoExecution = iterator.next()))) {
            list.add(mojoExecution);
        }
        return list;
    }

    private String resolveMojoExecutionLifecyclePhase(MavenProject project, MojoExecution mojoExecution) {
        MojoExecution forkOrigin = (MojoExecution)this.forkedProjectToOrigin.get(project);
        if (forkOrigin == null) {
            return mojoExecution.getLifecyclePhase();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Mojo execution {} is forked, returning phase {} from originating mojo {}", new Object[]{CacheUtils.mojoExecutionKey(mojoExecution), forkOrigin.getLifecyclePhase(), CacheUtils.mojoExecutionKey(forkOrigin)});
        }
        return forkOrigin.getLifecyclePhase();
    }

    public List<MojoExecution> getCachedSegment(MavenProject project, List<MojoExecution> mojoExecutions, Build build) {
        ArrayList<MojoExecution> list = new ArrayList<MojoExecution>(mojoExecutions.size());
        for (MojoExecution mojoExecution : mojoExecutions) {
            String lifecyclePhase = this.resolveMojoExecutionLifecyclePhase(project, mojoExecution);
            if (!this.isLaterPhaseThanClean(lifecyclePhase)) continue;
            if (this.isLaterPhaseThanBuild(lifecyclePhase, build)) break;
            list.add(mojoExecution);
        }
        return list;
    }

    public List<MojoExecution> getPostCachedSegment(MavenProject project, List<MojoExecution> mojoExecutions, Build build) {
        ArrayList<MojoExecution> list = new ArrayList<MojoExecution>(mojoExecutions.size());
        for (MojoExecution mojoExecution : mojoExecutions) {
            String lifecyclePhase = this.resolveMojoExecutionLifecyclePhase(project, mojoExecution);
            if (!this.isLaterPhaseThanBuild(lifecyclePhase, build)) continue;
            list.add(mojoExecution);
        }
        return list;
    }

    public boolean isForkedProject(MavenProject project) {
        return this.forkedProjectToOrigin.containsKey(project);
    }
}

