/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.artifact;

public enum OutputType {
    ARTIFACT(""),
    GENERATED_SOURCE("mvn-cache-ext-generated-source-"),
    EXTRA_OUTPUT("mvn-cache-ext-extra-output-");

    private String classifierPrefix;

    private OutputType(String getClassifierPrefix) {
        this.classifierPrefix = getClassifierPrefix;
    }

    public String getClassifierPrefix() {
        return this.classifierPrefix;
    }

    public static OutputType fromClassifier(String classifier) {
        if (classifier != null) {
            if (classifier.startsWith(OutputType.GENERATED_SOURCE.classifierPrefix)) {
                return GENERATED_SOURCE;
            }
            if (classifier.startsWith(OutputType.EXTRA_OUTPUT.classifierPrefix)) {
                return EXTRA_OUTPUT;
            }
        }
        return ARTIFACT;
    }
}

