/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.buildcache.xml.build.Build;
import org.apache.maven.buildcache.xml.build.io.xpp3.BuildCacheBuildXpp3Reader;
import org.apache.maven.buildcache.xml.build.io.xpp3.BuildCacheBuildXpp3Writer;
import org.apache.maven.buildcache.xml.config.CacheConfig;
import org.apache.maven.buildcache.xml.config.io.xpp3.BuildCacheConfigXpp3Reader;
import org.apache.maven.buildcache.xml.config.io.xpp3.BuildCacheConfigXpp3Writer;
import org.apache.maven.buildcache.xml.diff.Diff;
import org.apache.maven.buildcache.xml.diff.io.xpp3.BuildCacheDiffXpp3Reader;
import org.apache.maven.buildcache.xml.diff.io.xpp3.BuildCacheDiffXpp3Writer;
import org.apache.maven.buildcache.xml.report.CacheReport;
import org.apache.maven.buildcache.xml.report.io.xpp3.BuildCacheReportXpp3Reader;
import org.apache.maven.buildcache.xml.report.io.xpp3.BuildCacheReportXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Singleton
@Named
public class XmlService {
    public byte[] toBytes(CacheConfig cache) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            new BuildCacheConfigXpp3Writer().write(baos, cache);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public byte[] toBytes(Build build) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            new BuildCacheBuildXpp3Writer().write(baos, build);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public byte[] toBytes(Diff diff) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            new BuildCacheDiffXpp3Writer().write(baos, diff);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public byte[] toBytes(CacheReport cacheReportType) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            new BuildCacheReportXpp3Writer().write(baos, cacheReportType);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public Build loadBuild(File file) throws IOException {
        return this.fromFile(Build.class, file);
    }

    public Build loadBuild(byte[] bytes) {
        return this.fromBytes(Build.class, bytes);
    }

    public Build loadBuild(InputStream inputStream) {
        return this.fromInputStream(Build.class, inputStream);
    }

    public CacheConfig loadCacheConfig(File file) throws IOException {
        return this.fromFile(CacheConfig.class, file);
    }

    public CacheConfig loadCacheConfig(byte[] bytes) {
        return this.fromBytes(CacheConfig.class, bytes);
    }

    public CacheConfig loadCacheConfig(InputStream inputStream) {
        return this.fromInputStream(CacheConfig.class, inputStream);
    }

    public CacheReport loadCacheReport(File file) throws IOException {
        return this.fromFile(CacheReport.class, file);
    }

    public CacheReport loadCacheReport(byte[] bytes) {
        return this.fromBytes(CacheReport.class, bytes);
    }

    public CacheReport loadCacheReport(InputStream inputStream) {
        return this.fromInputStream(CacheReport.class, inputStream);
    }

    public Diff loadDiff(File file) throws IOException {
        return this.fromFile(Diff.class, file);
    }

    public Diff loadDiff(byte[] bytes) {
        return this.fromBytes(Diff.class, bytes);
    }

    public Diff loadDiff(InputStream inputStream) {
        return this.fromInputStream(Diff.class, inputStream);
    }

    private <T> T fromFile(Class<T> clazz, File file) throws IOException {
        return this.fromInputStream(clazz, Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    private <T> T fromBytes(Class<T> clazz, byte[] bytes) {
        return this.fromInputStream(clazz, new ByteArrayInputStream(bytes));
    }

    private <T> T fromInputStream(Class<T> clazz, InputStream inputStream) {
        try {
            if (clazz == Build.class) {
                T t = clazz.cast(new BuildCacheBuildXpp3Reader().read(inputStream));
                return t;
            }
            if (clazz == CacheConfig.class) {
                T t = clazz.cast(new BuildCacheConfigXpp3Reader().read(inputStream));
                return t;
            }
            if (clazz == Diff.class) {
                T t = clazz.cast(new BuildCacheDiffXpp3Reader().read(inputStream));
                return t;
            }
            if (clazz == CacheReport.class) {
                T t = clazz.cast(new BuildCacheReportXpp3Reader().read(inputStream));
                return t;
            }
            try {
                throw new IllegalArgumentException("Unsupported type " + clazz);
            }
            catch (IOException | XmlPullParserException e) {
                throw new RuntimeException("Unable to parse cache xml element", e);
            }
        }
        finally {
            this.closeQuietly(inputStream);
        }
    }

    private void closeQuietly(InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

