/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import org.apache.maven.model.building.ModelProblem;

public class Result<T> {
    private final boolean errors;
    private final T value;
    private final Iterable<? extends ModelProblem> problems;
    private static final Function<Result<?>, Iterable<? extends ModelProblem>> GET_PROBLEMS = new Function<Result<?>, Iterable<? extends ModelProblem>>(){

        public Iterable<? extends ModelProblem> apply(Result<?> input) {
            return input.getProblems();
        }
    };

    public static <T> Result<T> success(T model) {
        return Result.success(model, Collections.emptyList());
    }

    public static <T> Result<T> success(T model, Iterable<? extends ModelProblem> problems) {
        assert (!Result.hasErrors(problems));
        return new Result<T>(false, model, problems);
    }

    public static <T> Result<T> success(T model, Result<?> ... results) {
        return Result.success(model, Iterables.concat((Iterable)Iterables.transform(Arrays.asList(results), GET_PROBLEMS)));
    }

    public static <T> Result<T> error(Iterable<? extends ModelProblem> problems) {
        return Result.error(null, problems);
    }

    public static <T> Result<T> error(T model) {
        return Result.error(model, Collections.emptyList());
    }

    public static <T> Result<T> error(Result<?> result) {
        return Result.error(result.getProblems());
    }

    public static <T> Result<T> error(Result<?> ... results) {
        return Result.error(Iterables.concat((Iterable)Iterables.transform(Arrays.asList(results), GET_PROBLEMS)));
    }

    public static <T> Result<T> error(T model, Iterable<? extends ModelProblem> problems) {
        return new Result<T>(true, model, problems);
    }

    public static <T> Result<T> newResult(T model, Iterable<? extends ModelProblem> problems) {
        return new Result<T>(Result.hasErrors(problems), model, problems);
    }

    public static <T> Result<T> addProblem(Result<T> result, ModelProblem problem) {
        return Result.addProblems(result, Collections.singleton(problem));
    }

    public static <T> Result<T> addProblems(Result<T> result, Iterable<? extends ModelProblem> problems) {
        return new Result<T>(result.hasErrors() || Result.hasErrors(problems), result.get(), Iterables.concat(result.getProblems(), problems));
    }

    public static <T> Result<T> addProblems(Result<T> result, Result<?> ... results) {
        return Result.addProblems(result, Iterables.concat((Iterable)Iterables.transform(Arrays.asList(results), GET_PROBLEMS)));
    }

    public static <T> Result<Iterable<T>> newResultSet(Iterable<? extends Result<? extends T>> results) {
        boolean hasErrors = Iterables.any((Iterable)Iterables.transform(results, (Function)new Function<Result<?>, Boolean>(){

            public Boolean apply(Result<?> input) {
                return input.hasErrors();
            }
        }), (Predicate)Predicates.equalTo((Object)true));
        Iterable models = Iterables.transform(results, (Function)new Function<Result<? extends T>, T>(){

            public T apply(Result<? extends T> input) {
                return input.get();
            }
        });
        Iterable problems = Iterables.concat((Iterable)Iterables.transform(results, GET_PROBLEMS));
        return new Result<Iterable<T>>(hasErrors, models, problems);
    }

    private static boolean hasErrors(Iterable<? extends ModelProblem> problems) {
        return Iterables.any((Iterable)Iterables.transform(problems, (Function)new Function<ModelProblem, ModelProblem.Severity>(){

            public ModelProblem.Severity apply(ModelProblem input) {
                return input.getSeverity();
            }
        }), (Predicate)Predicates.in(EnumSet.of(ModelProblem.Severity.ERROR, ModelProblem.Severity.FATAL)));
    }

    private Result(boolean errors, T model, Iterable<? extends ModelProblem> problems) {
        this.errors = errors;
        this.value = model;
        this.problems = problems;
    }

    public Iterable<? extends ModelProblem> getProblems() {
        return this.problems;
    }

    public T get() {
        return this.value;
    }

    public boolean hasErrors() {
        return this.errors;
    }
}

