/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.xml;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.xml.Dom;
import org.apache.maven.internal.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.SerializerXMLWriter;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class Xpp3Dom
implements Serializable,
Dom {
    private static final long serialVersionUID = 2567894443061173996L;
    protected final String name;
    protected final String value;
    protected final Map<String, String> attributes;
    protected final List<Dom> children;
    protected final Object location;

    public Xpp3Dom(String name) {
        this(name, null, null, null, null);
    }

    public Xpp3Dom(String name, String value) {
        this(name, value, null, null, null);
    }

    public Xpp3Dom(Dom from, String name) {
        this(name, from.getValue(), from.getAttributes(), from.getChildren(), from.getInputLocation());
    }

    public Xpp3Dom(String name, String value, Map<String, String> attributes, List<Dom> children, Object location) {
        this.name = Objects.requireNonNull(name);
        this.value = value;
        this.attributes = attributes != null ? Collections.unmodifiableMap(new HashMap<String, String>(attributes)) : Collections.emptyMap();
        this.children = children != null ? Collections.unmodifiableList(new ArrayList<Dom>(children)) : Collections.emptyList();
        this.location = location;
    }

    @Override
    public Dom merge(Dom source, Boolean childMergeOverride) {
        return Xpp3Dom.merge(this, source, childMergeOverride);
    }

    @Override
    public Dom clone() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Dom getChild(String name) {
        if (name != null) {
            ListIterator<Dom> it = this.children.listIterator(this.children.size());
            while (it.hasPrevious()) {
                Dom child = it.previous();
                if (!name.equals(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    @Override
    public List<Dom> getChildren() {
        return this.children;
    }

    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public Object getInputLocation() {
        return this.location;
    }

    public void writeToSerializer(String namespace, XmlSerializer serializer) throws IOException {
        SerializerXMLWriter xmlWriter = new SerializerXMLWriter(namespace, serializer);
        Xpp3DomWriter.write(xmlWriter, (Dom)this);
        if (xmlWriter.getExceptions().size() > 0) {
            throw (IOException)xmlWriter.getExceptions().get(0);
        }
    }

    public static Dom merge(Dom dominant, Dom recessive, Boolean childMergeOverride) {
        if (recessive == null) {
            return dominant;
        }
        if (dominant == null) {
            return recessive;
        }
        boolean mergeSelf = true;
        String selfMergeMode = dominant.getAttribute("combine.self");
        if ("override".equals(selfMergeMode)) {
            mergeSelf = false;
        }
        if (mergeSelf) {
            String value = null;
            Object location = null;
            Map<String, String> attrs = null;
            List<Dom> children = null;
            if (Xpp3Dom.isEmpty(dominant.getValue()) && !Xpp3Dom.isEmpty(recessive.getValue())) {
                value = recessive.getValue();
                location = recessive.getInputLocation();
            }
            for (Map.Entry<String, String> attr : recessive.getAttributes().entrySet()) {
                String key = attr.getKey();
                if (!Xpp3Dom.isEmpty(dominant.getAttribute(key)) || "combine.self".equals(key)) continue;
                if (attrs == null) {
                    attrs = new HashMap<String, String>();
                }
                attrs.put(key, attr.getValue());
            }
            if (recessive.getChildren().size() > 0) {
                boolean mergeChildren = true;
                if (childMergeOverride != null) {
                    mergeChildren = childMergeOverride;
                } else {
                    String childMergeMode = dominant.getAttribute("combine.children");
                    if ("append".equals(childMergeMode)) {
                        mergeChildren = false;
                    }
                }
                if (!mergeChildren) {
                    children = new ArrayList<Dom>(recessive.getChildren().size() + dominant.getChildren().size());
                    children.addAll(recessive.getChildren());
                    children.addAll(dominant.getChildren());
                } else {
                    HashMap<String, Iterator> commonChildren = new HashMap<String, Iterator>();
                    Set names = recessive.getChildren().stream().map(Dom::getName).collect(Collectors.toSet());
                    for (String name : names) {
                        List dominantChildren = dominant.getChildren().stream().filter(n -> n.getName().equals(name)).collect(Collectors.toList());
                        if (dominantChildren.size() <= 0) continue;
                        commonChildren.put(name, dominantChildren.iterator());
                    }
                    for (Dom recessiveChild : recessive.getChildren()) {
                        String name = recessiveChild.getName();
                        Iterator it = commonChildren.computeIfAbsent(name, n1 -> Stream.of(dominant.getChildren().stream().filter(n2 -> n2.getName().equals(n1)).collect(Collectors.toList())).filter(l -> !l.isEmpty()).map(List::iterator).findFirst().orElse(null));
                        if (it == null) {
                            if (children == null) {
                                children = new ArrayList<Dom>(dominant.getChildren());
                            }
                            children.add(recessiveChild);
                            continue;
                        }
                        if (!it.hasNext()) continue;
                        Dom dominantChild = (Dom)it.next();
                        String dominantChildCombinationMode = dominantChild.getAttribute("combine.self");
                        if ("remove".equals(dominantChildCombinationMode)) {
                            if (children == null) {
                                children = new ArrayList<Dom>(dominant.getChildren());
                            }
                            children.remove(dominantChild);
                            continue;
                        }
                        int idx = (children != null ? children : dominant.getChildren()).indexOf(dominantChild);
                        Dom merged = Xpp3Dom.merge(dominantChild, recessiveChild, childMergeOverride);
                        if (merged == dominantChild) continue;
                        if (children == null) {
                            children = new ArrayList<Dom>(dominant.getChildren());
                        }
                        children.set(idx, merged);
                    }
                }
            }
            if (value != null || attrs != null || children != null) {
                if (attrs != null) {
                    Map<String, String> nattrs = attrs;
                    attrs = new HashMap<String, String>(dominant.getAttributes());
                    attrs.putAll(nattrs);
                } else {
                    attrs = dominant.getAttributes();
                }
                if (children == null) {
                    children = dominant.getChildren();
                }
                return new Xpp3Dom(dominant.getName(), value != null ? value : dominant.getValue(), attrs, children, location);
            }
        }
        return dominant;
    }

    public static Dom merge(Dom dominant, Dom recessive) {
        return Xpp3Dom.merge(dominant, recessive, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Xpp3Dom xpp3Dom = (Xpp3Dom)o;
        return this.name.equals(xpp3Dom.name) && Objects.equals(this.value, xpp3Dom.value) && this.attributes.equals(xpp3Dom.attributes) && this.children.equals(xpp3Dom.children);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.attributes, this.children);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        Xpp3DomWriter.write(writer, (Dom)this);
        return writer.toString();
    }

    public String toUnescapedString() {
        StringWriter writer = new StringWriter();
        PrettyPrintXMLWriter xmlWriter = new PrettyPrintXMLWriter(writer);
        Xpp3DomWriter.write(xmlWriter, this, false);
        return writer.toString();
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

