/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.compiler.module.JavaModuleDescriptor;
import org.apache.maven.plugin.compiler.module.ModuleInfoParser;
import org.apache.maven.plugin.compiler.module.ProjectAnalyzerRequest;
import org.apache.maven.plugin.compiler.module.ProjectAnalyzerResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=ProjectAnalyzer.class)
public class ProjectAnalyzer
extends AbstractLogEnabled {
    @Requirement(hint="asm")
    private ModuleInfoParser asmParser;
    @Requirement(hint="reflect")
    private ModuleInfoParser reflectParser;

    public ProjectAnalyzerResult analyze(ProjectAnalyzerRequest request) throws IOException {
        ProjectAnalyzerResult result = new ProjectAnalyzerResult();
        LinkedHashMap<File, JavaModuleDescriptor> pathElements = new LinkedHashMap<File, JavaModuleDescriptor>(request.getDependencyArtifacts().size());
        JavaModuleDescriptor baseModuleDescriptor = request.getBaseModuleDescriptor();
        HashMap<String, JavaModuleDescriptor> availableNamedModules = new HashMap<String, JavaModuleDescriptor>();
        HashMap<String, ProjectAnalyzerResult.ModuleNameSource> moduleNameSources = new HashMap<String, ProjectAnalyzerResult.ModuleNameSource>();
        result.setBaseModuleDescriptor(baseModuleDescriptor);
        for (File file : request.getDependencyArtifacts()) {
            JavaModuleDescriptor descriptor = this.extractDescriptor(file);
            if (descriptor != null) {
                availableNamedModules.put(descriptor.name(), descriptor);
            }
            if (descriptor == null || descriptor.isAutomatic()) {
                Manifest manifest = this.extractManifest(file);
                String modulename = null;
                if (manifest != null) {
                    modulename = manifest.getMainAttributes().getValue("Automatic-Module-Name");
                }
                if (modulename != null) {
                    moduleNameSources.put(modulename, ProjectAnalyzerResult.ModuleNameSource.MANIFEST);
                } else if (descriptor != null) {
                    moduleNameSources.put(descriptor.name(), ProjectAnalyzerResult.ModuleNameSource.FILENAME);
                }
            } else {
                moduleNameSources.put(descriptor.name(), ProjectAnalyzerResult.ModuleNameSource.MODULEDESCRIPTOR);
            }
            pathElements.put(file, descriptor);
        }
        result.setPathElements(pathElements);
        result.setModuleNameSources(moduleNameSources);
        if (baseModuleDescriptor != null) {
            HashSet<String> requiredNamedModules = new HashSet<String>();
            HashSet<String> requiredUnnamedModules = new HashSet<String>();
            this.select(baseModuleDescriptor, Collections.unmodifiableMap(availableNamedModules), requiredNamedModules, requiredUnnamedModules);
            result.setRequiredNormalModules(requiredNamedModules);
            result.setRequiredAutomaticModules(requiredUnnamedModules);
        }
        return result;
    }

    private JavaModuleDescriptor extractDescriptor(File file) throws IOException {
        JavaModuleDescriptor moduleDescriptor;
        if (file.isFile() || new File(file, "module-info.class").exists()) {
            moduleDescriptor = this.reflectParser.getModuleDescriptor(file);
            if (moduleDescriptor == null) {
                moduleDescriptor = this.asmParser.getModuleDescriptor(file);
            }
        } else {
            moduleDescriptor = null;
        }
        return moduleDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest extractManifest(File file) throws IOException {
        Manifest manifest;
        if (file.isFile()) {
            ZipFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                manifest = ((JarFile)jarFile).getManifest();
            }
            finally {
                jarFile.close();
            }
        } else {
            manifest = new File(file, "META-INF/MANIFEST.MF").exists() ? new Manifest(new FileInputStream(new File(file, "META-INF/MANIFEST.MF"))) : null;
        }
        return manifest;
    }

    private void select(JavaModuleDescriptor module, Map<String, JavaModuleDescriptor> availableModules, Set<String> namedModules, Set<String> unnamedModules) {
        for (JavaModuleDescriptor.JavaRequires requires : module.requires()) {
            String requiresName = requires.name();
            JavaModuleDescriptor requiredModule = availableModules.get(requiresName);
            if (requiredModule != null && !requiredModule.isAutomatic()) {
                if (!namedModules.add(requiresName)) continue;
                this.select(requiredModule, availableModules, namedModules, unnamedModules);
                continue;
            }
            unnamedModules.add(requiresName);
        }
    }
}

