/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromConfiguration;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.plugins.dependency.utils.DependencyUtil;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.codehaus.plexus.util.StringUtils;

public class ArtifactItem
implements DependableCoordinate {
    private String groupId;
    private String artifactId;
    private String version = null;
    private String type = "jar";
    private String classifier;
    private File outputDirectory;
    private String destFileName;
    private String overWrite;
    private String encoding;
    private boolean needsProcessing;
    private Artifact artifact;
    private String includes;
    private String excludes;

    public ArtifactItem() {
    }

    public ArtifactItem(Artifact artifact) {
        this.setArtifact(artifact);
        this.setArtifactId(artifact.getArtifactId());
        this.setClassifier(artifact.getClassifier());
        this.setGroupId(artifact.getGroupId());
        this.setType(artifact.getType());
        this.setVersion(artifact.getVersion());
    }

    private String filterEmptyString(String in) {
        if ("".equals(in)) {
            return null;
        }
        return in;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String theArtifact) {
        this.artifactId = this.filterEmptyString(theArtifact);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = this.filterEmptyString(groupId);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = this.filterEmptyString(type);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = this.filterEmptyString(version);
    }

    public String getBaseVersion() {
        return ArtifactUtils.toSnapshotVersion((String)this.version);
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = this.filterEmptyString(classifier);
    }

    public String toString() {
        if (this.classifier == null) {
            return this.groupId + ":" + this.artifactId + ":" + StringUtils.defaultString((Object)this.version, (String)"?") + ":" + this.type;
        }
        return this.groupId + ":" + this.artifactId + ":" + this.classifier + ":" + StringUtils.defaultString((Object)this.version, (String)"?") + ":" + this.type;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getDestFileName() {
        return this.destFileName;
    }

    public void setDestFileName(String destFileName) {
        this.destFileName = this.filterEmptyString(destFileName);
    }

    public boolean isNeedsProcessing() {
        return this.needsProcessing;
    }

    public void setNeedsProcessing(boolean needsProcessing) {
        this.needsProcessing = needsProcessing;
    }

    public String getOverWrite() {
        return this.overWrite;
    }

    public void setOverWrite(String overWrite) {
        this.overWrite = overWrite;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public String getExcludes() {
        return DependencyUtil.cleanToBeTokenizedString(this.excludes);
    }

    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    public String getIncludes() {
        return DependencyUtil.cleanToBeTokenizedString(this.includes);
    }

    public void setIncludes(String includes) {
        this.includes = includes;
    }
}

