/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugins.dependency.tree.ArtifactKey;
import org.apache.maven.plugins.dependency.tree.CycleBreakerGraphTransformer;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.eclipse.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.eclipse.aether.util.graph.transformer.JavaDependencyContextRefiner;

class VerboseDependencyGraphBuilder {
    private static final String PRE_MANAGED_SCOPE = "preManagedScope";
    private static final String PRE_MANAGED_VERSION = "preManagedVersion";
    private static final String MANAGED_SCOPE = "managedScope";

    VerboseDependencyGraphBuilder() {
    }

    public DependencyNode buildVerboseGraph(MavenProject project, ProjectDependenciesResolver resolver, RepositorySystemSession repositorySystemSession, Collection<MavenProject> reactorProjects, ProjectBuildingRequest buildingRequest) throws DependencyGraphBuilderException {
        DependencyNode rootNode;
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setLocalRepositoryManager(repositorySystemSession.getLocalRepositoryManager());
        AndDependencySelector dependencySelector = new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[0]), new ExclusionDependencySelector()});
        session.setDependencySelector((DependencySelector)dependencySelector);
        session.setDependencyGraphTransformer((DependencyGraphTransformer)new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{new CycleBreakerGraphTransformer(), new JavaDependencyContextRefiner()}));
        session.setDependencyManager(null);
        DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest();
        request.setMavenProject(buildingRequest.getProject());
        request.setRepositorySession((RepositorySystemSession)session);
        boolean reactor = false;
        try {
            rootNode = resolver.resolve((DependencyResolutionRequest)request).getDependencyGraph();
        }
        catch (DependencyResolutionException e) {
            DefaultDependencyResolutionRequest reactorRequest = new DefaultDependencyResolutionRequest();
            reactorRequest.setMavenProject(buildingRequest.getProject());
            reactorRequest.setRepositorySession(buildingRequest.getRepositorySession());
            try {
                rootNode = resolver.resolve((DependencyResolutionRequest)reactorRequest).getDependencyGraph();
            }
            catch (DependencyResolutionException exception) {
                if (reactorProjects == null) {
                    throw new DependencyGraphBuilderException("Could not resolve following dependencies: " + exception.getResult().getUnresolvedDependencies(), (Throwable)exception);
                }
                reactor = true;
                rootNode = this.collectDependenciesFromReactor(exception, reactorProjects).getDependencyGraph();
                rootNode.setData((Object)"ContainsModule", (Object)"True");
            }
        }
        DependencyNode prunedRoot = this.pruneTransitiveTestDependencies(rootNode, project);
        this.applyDependencyManagement(project, prunedRoot);
        if (reactor) {
            prunedRoot.setData((Object)"ContainsModule", (Object)"True");
        }
        return prunedRoot;
    }

    private void applyDependencyManagement(MavenProject project, DependencyNode root) {
        Map<String, Dependency> dependencyManagementMap = VerboseDependencyGraphBuilder.createDependencyManagementMap(project.getDependencyManagement());
        for (DependencyNode child : root.getChildren()) {
            for (DependencyNode nonTransitiveDependencyNode : child.getChildren()) {
                this.applyDependencyManagementDfs(dependencyManagementMap, nonTransitiveDependencyNode);
            }
        }
    }

    private void applyDependencyManagementDfs(Map<String, Dependency> dependencyManagementMap, DependencyNode node) {
        if (dependencyManagementMap.containsKey(VerboseDependencyGraphBuilder.getDependencyManagementCoordinate(node.getArtifact()))) {
            org.eclipse.aether.graph.Dependency dependency;
            String dependencyScope;
            String managerScope;
            Dependency manager = dependencyManagementMap.get(VerboseDependencyGraphBuilder.getDependencyManagementCoordinate(node.getArtifact()));
            HashMap artifactProperties = new HashMap();
            for (Map.Entry entry : node.getArtifact().getProperties().entrySet()) {
                artifactProperties.put(entry.getKey(), entry.getValue());
            }
            if (!manager.getVersion().equals(node.getArtifact().getVersion())) {
                artifactProperties.put(PRE_MANAGED_VERSION, node.getArtifact().getVersion());
                node.setArtifact(node.getArtifact().setVersion(manager.getVersion()));
            }
            if (!(managerScope = Objects.toString(manager.getScope(), "compile")).equals(dependencyScope = (dependency = node.getDependency()).getScope())) {
                artifactProperties.put(PRE_MANAGED_SCOPE, dependencyScope);
                artifactProperties.put(MANAGED_SCOPE, managerScope);
            }
            node.setArtifact(node.getArtifact().setProperties(artifactProperties));
            dependency.setArtifact(dependency.getArtifact().setProperties(artifactProperties));
        }
        for (DependencyNode child : node.getChildren()) {
            this.applyDependencyManagementDfs(dependencyManagementMap, child);
        }
    }

    private static Map<String, Dependency> createDependencyManagementMap(DependencyManagement dependencyManagement) {
        HashMap<String, Dependency> dependencyManagementMap = new HashMap<String, Dependency>();
        if (dependencyManagement == null) {
            return dependencyManagementMap;
        }
        for (Dependency dependency : dependencyManagement.getDependencies()) {
            dependencyManagementMap.put(VerboseDependencyGraphBuilder.getDependencyManagementCoordinate(dependency), dependency);
        }
        return dependencyManagementMap;
    }

    private static String getDependencyManagementCoordinate(Dependency dependency) {
        StringBuilder builder = new StringBuilder();
        builder.append(dependency.getGroupId()).append(":").append(dependency.getArtifactId()).append(":").append(dependency.getType());
        if (dependency.getClassifier() != null && !dependency.getClassifier().equals("")) {
            builder.append(":").append(dependency.getClassifier());
        }
        return builder.toString();
    }

    private static String getDependencyManagementCoordinate(Artifact artifact) {
        StringBuilder builder = new StringBuilder();
        builder.append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getExtension());
        if (artifact.getClassifier() != null && !artifact.getClassifier().equals("")) {
            builder.append(":").append(artifact.getClassifier());
        }
        return builder.toString();
    }

    private org.eclipse.aether.graph.Dependency getProjectDependency(MavenProject project) {
        Model model = project.getModel();
        return new org.eclipse.aether.graph.Dependency((Artifact)new DefaultArtifact(model.getGroupId(), model.getArtifactId(), model.getPackaging(), model.getVersion()), "");
    }

    private DependencyNode pruneTransitiveTestDependencies(DependencyNode rootNode, MavenProject project) {
        HashSet<DependencyNode> visitedNodes = new HashSet<DependencyNode>();
        DefaultDependencyNode newRoot = new DefaultDependencyNode(this.getProjectDependency(project));
        newRoot.setChildren(new ArrayList());
        for (int i = 0; i < rootNode.getChildren().size(); ++i) {
            DependencyNode childNode = (DependencyNode)rootNode.getChildren().get(i);
            newRoot.getChildren().add(childNode);
            this.pruneTransitiveTestDependenciesDfs(childNode, visitedNodes);
        }
        return newRoot;
    }

    private void pruneTransitiveTestDependenciesDfs(DependencyNode node, Set<DependencyNode> visitedNodes) {
        if (!visitedNodes.contains(node)) {
            visitedNodes.add(node);
            Iterator iterator = node.getChildren().iterator();
            while (iterator.hasNext()) {
                DependencyNode child = (DependencyNode)iterator.next();
                if (child.getDependency().getScope().equals("test")) {
                    iterator.remove();
                    continue;
                }
                this.pruneTransitiveTestDependenciesDfs(child, visitedNodes);
            }
        }
    }

    private DependencyResolutionResult collectDependenciesFromReactor(DependencyResolutionException e, Collection<MavenProject> reactorProjects) throws DependencyGraphBuilderException {
        DependencyResolutionResult result = e.getResult();
        List<org.eclipse.aether.graph.Dependency> reactorDeps = this.getReactorDependencies(reactorProjects, result.getUnresolvedDependencies());
        result.getUnresolvedDependencies().removeAll(reactorDeps);
        result.getResolvedDependencies().addAll(reactorDeps);
        if (!result.getUnresolvedDependencies().isEmpty()) {
            throw new DependencyGraphBuilderException("Could not resolve nor collect following dependencies: " + result.getUnresolvedDependencies(), (Throwable)e);
        }
        return result;
    }

    private List<org.eclipse.aether.graph.Dependency> getReactorDependencies(Collection<MavenProject> reactorProjects, List<?> dependencies) {
        HashSet<ArtifactKey> reactorProjectsIds = new HashSet<ArtifactKey>();
        for (MavenProject project : reactorProjects) {
            reactorProjectsIds.add(new ArtifactKey(project));
        }
        ArrayList<org.eclipse.aether.graph.Dependency> reactorDeps = new ArrayList<org.eclipse.aether.graph.Dependency>();
        for (Object untypedDependency : dependencies) {
            org.eclipse.aether.graph.Dependency dependency = (org.eclipse.aether.graph.Dependency)untypedDependency;
            Artifact depArtifact = dependency.getArtifact();
            ArtifactKey key = new ArtifactKey(depArtifact.getGroupId(), depArtifact.getArtifactId(), depArtifact.getVersion());
            if (!reactorProjectsIds.contains(key)) continue;
            reactorDeps.add(dependency);
        }
        return reactorDeps;
    }
}

