/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.maven.plugins.dependency.tree.AbstractVerboseGraphSerializer;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;

class VerboseGraphTextSerializer
extends AbstractVerboseGraphSerializer {
    VerboseGraphTextSerializer() {
    }

    @Override
    public String serialize(DependencyNode root) {
        HashSet<String> coordinateStrings = new HashSet<String>();
        HashMap<String, String> coordinateVersionMap = new HashMap<String, String>();
        Map<DependencyNode, String> nodeErrors = this.getNodeConflictMessagesBfs(root, coordinateStrings, coordinateVersionMap);
        StringBuilder builder = new StringBuilder();
        Artifact rootArtifact = root.getArtifact();
        builder.append(rootArtifact.getGroupId()).append(":").append(rootArtifact.getArtifactId()).append(":").append(rootArtifact.getExtension()).append(":").append(rootArtifact.getVersion());
        if (root.getData().containsKey("ContainsModule")) {
            builder.append(" WARNING: this tree contains a submodule. Once it reaches the submodule will print in nonVerbose fashion, to see the actual submodule verbose output refer to the rest of the output");
        }
        builder.append("\n");
        for (int i = 0; i < root.getChildren().size(); ++i) {
            if (i == root.getChildren().size() - 1) {
                this.dfsPrint((DependencyNode)root.getChildren().get(i), "\\- ", builder, nodeErrors);
                continue;
            }
            this.dfsPrint((DependencyNode)root.getChildren().get(i), "+- ", builder, nodeErrors);
        }
        return builder.toString();
    }

    private void dfsPrint(DependencyNode node, String start, StringBuilder builder, Map<DependencyNode, String> nodeErrors) {
        builder.append(start);
        if (node.getArtifact() == null) {
            builder.append("Null Artifact Node").append("\n");
            this.callDfsPrint(node, start, builder, nodeErrors);
        }
        String coordString = "";
        boolean messageAdded = false;
        if (node.getArtifact().getProperties().containsKey("preManagedVersion")) {
            coordString = coordString + " - version managed from " + (String)node.getArtifact().getProperties().get("preManagedVersion");
            messageAdded = true;
        }
        if (node.getArtifact().getProperties().containsKey("preManagedScope")) {
            if (messageAdded) {
                coordString = coordString + "; ";
            } else {
                coordString = coordString + " - ";
                messageAdded = true;
            }
            coordString = coordString + "scope managed from " + (String)node.getArtifact().getProperties().get("preManagedScope");
        }
        coordString = VerboseGraphTextSerializer.getDependencyCoordinate(node) + coordString;
        if (node.getArtifact().getProperties().containsKey("Cycle")) {
            coordString = messageAdded ? coordString + "; " : coordString + " - ";
            coordString = coordString + "omitted for cycle";
            builder.append("(").append(coordString).append(")").append("\n");
        } else if (nodeErrors.get(node) != null) {
            builder.append("(");
            if (messageAdded) {
                builder.append(coordString).append("; ").append(nodeErrors.get(node));
            } else {
                builder.append(coordString).append(" - ").append(nodeErrors.get(node));
            }
            builder.append(")");
            builder.append("\n");
        } else {
            builder.append(coordString).append("\n");
            this.callDfsPrint(node, start, builder, nodeErrors);
        }
    }

    private void callDfsPrint(DependencyNode node, String start, StringBuilder builder, Map<DependencyNode, String> nodeErrors) {
        for (int i = 0; i < node.getChildren().size(); ++i) {
            if (start.endsWith("+- ")) {
                start = start.replace("+- ", "|  ");
            } else if (start.endsWith("\\- ")) {
                start = start.replace("\\- ", "   ");
            }
            if (i == node.getChildren().size() - 1) {
                this.dfsPrint((DependencyNode)node.getChildren().get(i), start.concat("\\- "), builder, nodeErrors);
                continue;
            }
            this.dfsPrint((DependencyNode)node.getChildren().get(i), start.concat("+- "), builder, nodeErrors);
        }
    }
}

