/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.io.Writer;
import org.apache.maven.plugins.dependency.tree.AbstractSerializingVisitor;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class GraphmlDependencyNodeVisitor
extends AbstractSerializingVisitor
implements DependencyNodeVisitor {
    private static final String GRAPHML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:y=\"http://www.yworks.com/xml/graphml\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">" + System.lineSeparator() + "  <key for=\"node\" id=\"d0\" yfiles.type=\"nodegraphics\"/> " + System.lineSeparator() + "  <key for=\"edge\" id=\"d1\" yfiles.type=\"edgegraphics\"/> " + System.lineSeparator() + "<graph id=\"dependencies\" edgedefault=\"directed\">" + System.lineSeparator();
    private static final String GRAPHML_FOOTER = "</graph></graphml>";

    public GraphmlDependencyNodeVisitor(Writer writer) {
        super(writer);
    }

    public boolean endVisit(DependencyNode node) {
        if (node.getParent() == null || node.getParent() == node) {
            this.writer.write(GRAPHML_FOOTER);
        } else {
            DependencyNode p = node.getParent();
            this.writer.print("<edge source=\"" + GraphmlDependencyNodeVisitor.generateId(p) + "\" target=\"" + GraphmlDependencyNodeVisitor.generateId(node) + "\">");
            if (node.getArtifact().getScope() != null) {
                this.writer.print("<data key=\"d1\"><y:PolyLineEdge><y:EdgeLabel>" + node.getArtifact().getScope() + "</y:EdgeLabel></y:PolyLineEdge></data>");
            }
            this.writer.println("</edge>");
        }
        return true;
    }

    public boolean visit(DependencyNode node) {
        if (node.getParent() == null || node.getParent() == node) {
            this.writer.write(GRAPHML_HEADER);
        }
        this.writer.print("<node id=\"" + GraphmlDependencyNodeVisitor.generateId(node) + "\">");
        this.writer.print("<data key=\"d0\"><y:ShapeNode><y:NodeLabel>" + node.toNodeString() + "</y:NodeLabel></y:ShapeNode></data>");
        this.writer.println("</node>");
        return true;
    }

    private static String generateId(DependencyNode node) {
        return String.valueOf(node.hashCode());
    }
}

