/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GpgVersion
implements Comparable<GpgVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.)+(\\d+)");
    private final int[] versionSegments;

    private GpgVersion(int ... versionSegments) {
        this.versionSegments = versionSegments;
    }

    public static GpgVersion parse(String rawVersion) {
        Matcher versionMatcher = VERSION_PATTERN.matcher(rawVersion);
        if (!versionMatcher.find()) {
            throw new IllegalArgumentException("Can't parse version of " + rawVersion);
        }
        String[] rawVersionSegments = versionMatcher.group(0).split("\\.");
        int[] versionSegments = new int[rawVersionSegments.length];
        for (int index = 0; index < rawVersionSegments.length; ++index) {
            versionSegments[index] = Integer.parseInt(rawVersionSegments[index]);
        }
        return new GpgVersion(versionSegments);
    }

    @Override
    public int compareTo(GpgVersion other) {
        int[] thisSegments = this.versionSegments;
        int[] otherSegments = other.versionSegments;
        int minSegments = Math.min(thisSegments.length, otherSegments.length);
        for (int index = 0; index < minSegments; ++index) {
            int compareValue = Integer.compare(thisSegments[index], otherSegments[index]);
            if (compareValue == 0) continue;
            return compareValue;
        }
        return thisSegments.length - otherSegments.length;
    }

    public boolean isBefore(GpgVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAtLeast(GpgVersion other) {
        return this.compareTo(other) >= 0;
    }

    public String toString() {
        if (this.versionSegments.length == 0) {
            return "";
        }
        StringBuilder versionStringBuilder = new StringBuilder();
        versionStringBuilder.append(this.versionSegments[0]);
        for (int index = 1; index < this.versionSegments.length; ++index) {
            versionStringBuilder.append('.').append(this.versionSegments[index]);
        }
        return versionStringBuilder.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GpgVersion)) {
            return false;
        }
        GpgVersion that = (GpgVersion)other;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.versionSegments);
    }
}

