/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.changelog.AbstractChangeLogCommand;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogSet;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgCommand;
import org.apache.maven.scm.provider.hg.command.changelog.HgChangeLogConsumer;

public class HgChangeLogCommand
extends AbstractChangeLogCommand
implements HgCommand {
    protected ChangeLogScmResult executeChangeLogCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, Date startDate, Date endDate, ScmBranch branch, String datePattern) throws ScmException {
        String[] cmd = new String[]{"log", "--verbose"};
        HgChangeLogConsumer consumer = new HgChangeLogConsumer(this.getLogger(), datePattern);
        ScmResult result = HgUtils.execute(consumer, this.getLogger(), fileSet.getBasedir(), cmd);
        List logEntries = consumer.getModifications();
        ArrayList<ChangeSet> inRangeAndValid = new ArrayList<ChangeSet>();
        startDate = startDate == null ? new Date(0L) : startDate;
        endDate = endDate == null ? new Date() : endDate;
        Iterator it = logEntries.iterator();
        while (it.hasNext()) {
            ChangeSet change = (ChangeSet)it.next();
            if (change.getFiles().size() <= 0 || change.getDate().before(startDate) || change.getDate().after(endDate)) continue;
            inRangeAndValid.add(change);
        }
        ChangeLogSet changeLogSet = new ChangeLogSet(inRangeAndValid, startDate, endDate);
        return new ChangeLogScmResult(changeLogSet, result);
    }
}

