/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.changelog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.maven.scm.ChangeFile;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

public class HgChangeLogConsumer
extends HgConsumer {
    private static final String TIME_PATTERN = "EEE MMM dd HH:mm:ss yyyy Z";
    private static final String REVNO_TAG = "changeset: ";
    private static final String TAG_TAG = "tag:         ";
    private static final String AUTHOR_TAG = "user: ";
    private static final String TIME_STAMP_TOKEN = "date: ";
    private static final String MESSAGE_TOKEN = "description:";
    private static final String MERGED_TOKEN = "merged: ";
    private static final String FILES_TOKEN = "files: ";
    private String prevLine = "";
    private String prevPrevLine = "";
    private ArrayList logEntries = new ArrayList();
    private ChangeSet currentChange;
    private ChangeSet lastChange;
    private boolean isMergeEntry;
    private String currentRevision;
    private String currentTag;
    private String userDatePattern;
    private boolean spoolingComments;
    private List currentComment = null;

    public HgChangeLogConsumer(ScmLogger logger, String userDatePattern) {
        super(logger);
        this.userDatePattern = userDatePattern;
    }

    public List getModifications() {
        return this.logEntries;
    }

    public void consumeLine(String line) {
        this.doConsume(null, line);
    }

    public void doConsume(ScmFileStatus status, String line) {
        int i;
        String tmpLine = line;
        if (line.equals("") && this.prevLine.equals("") && this.prevPrevLine.equals("") || this.currentComment == null) {
            CharSequence comment;
            if (this.currentComment != null) {
                comment = new StringBuffer();
                for (i = 0; i < this.currentComment.size() - 1; ++i) {
                    ((StringBuffer)comment).append(this.currentComment.get(i));
                    if (i + 1 >= this.currentComment.size() - 1) continue;
                    ((StringBuffer)comment).append('\n');
                }
                this.currentChange.setComment(((StringBuffer)comment).toString());
            }
            this.spoolingComments = false;
            if (this.isMergeEntry && this.lastChange != null) {
                comment = this.lastChange.getComment();
                comment = (String)comment + "\n[MAVEN]: Merged from " + this.currentChange.getAuthor();
                comment = (String)comment + "\n[MAVEN]:    " + this.currentChange.getDateFormatted();
                comment = (String)comment + "\n[MAVEN]:    " + this.currentChange.getComment();
                this.lastChange.setComment((String)comment);
            }
            this.currentChange = new ChangeSet();
            this.currentChange.setFiles(new ArrayList());
            this.logEntries.add(this.currentChange);
            this.currentComment = new ArrayList();
            this.currentRevision = "";
            this.isMergeEntry = false;
        }
        if (this.spoolingComments) {
            this.currentComment.add(line);
        } else if (line.startsWith(MESSAGE_TOKEN)) {
            this.spoolingComments = true;
        } else if (line.startsWith(MERGED_TOKEN)) {
            this.isMergeEntry = true;
            this.logEntries.remove(this.currentChange);
            if (this.logEntries.size() > 0) {
                this.lastChange = (ChangeSet)this.logEntries.get(this.logEntries.size() - 1);
            } else {
                this.getLogger().warn("First entry was unexpectedly a merged entry");
                this.lastChange = null;
            }
        } else if (line.startsWith(REVNO_TAG)) {
            tmpLine = line.substring(REVNO_TAG.length());
            this.currentRevision = tmpLine = tmpLine.trim();
        } else if (line.startsWith(TAG_TAG)) {
            this.currentTag = tmpLine = line.substring(TAG_TAG.length()).trim();
        } else if (line.startsWith(AUTHOR_TAG)) {
            tmpLine = line.substring(AUTHOR_TAG.length());
            tmpLine = tmpLine.trim();
            this.currentChange.setAuthor(tmpLine);
        } else if (line.startsWith(TIME_STAMP_TOKEN)) {
            tmpLine = line.substring(TIME_STAMP_TOKEN.length()).trim();
            Date date = this.parseDate(tmpLine, this.userDatePattern, TIME_PATTERN, Locale.ENGLISH);
            this.currentChange.setDate(date);
        } else if (line.startsWith(FILES_TOKEN)) {
            tmpLine = line.substring(FILES_TOKEN.length()).trim();
            String[] files = tmpLine.split(" ");
            for (i = 0; i < files.length; ++i) {
                String file = files[i];
                ChangeFile changeFile = new ChangeFile(file, this.currentRevision);
                this.currentChange.addFile(changeFile);
            }
        } else {
            this.getLogger().warn("Could not figure out: " + line);
        }
        this.prevPrevLine = this.prevLine = line;
    }
}

