/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.provider.hg.command.HgConsumer;

class HgStatusConsumer
extends HgConsumer {
    private final List<ScmFile> repositoryStatus = new ArrayList<ScmFile>();
    private final File workingDir;

    HgStatusConsumer(File workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public void doConsume(ScmFileStatus status, String trimmedLine) {
        File tmpFile = new File(this.workingDir, trimmedLine);
        if (!tmpFile.exists()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Not a file: " + tmpFile + ". Ignoring");
            }
        } else if (tmpFile.isDirectory()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("New directory added: " + tmpFile);
            }
        } else {
            ScmFile scmFile = new ScmFile(trimmedLine, status);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(scmFile.toString());
            }
            this.repositoryStatus.add(scmFile);
        }
    }

    List<ScmFile> getStatus() {
        return this.repositoryStatus;
    }
}

