/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.checkin;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.JazzScmCommand;
import org.apache.maven.scm.provider.jazz.command.add.JazzAddCommand;
import org.apache.maven.scm.provider.jazz.command.consumer.DebugLoggerConsumer;
import org.apache.maven.scm.provider.jazz.command.consumer.ErrorConsumer;
import org.apache.maven.scm.provider.jazz.command.status.JazzStatusCommand;
import org.apache.maven.scm.provider.jazz.repository.JazzScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JazzCheckInCommand
extends AbstractCheckInCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, ScmVersion scmVersion) throws ScmException {
        List<Integer> changeSetAliases;
        ErrorConsumer errConsumer;
        DebugLoggerConsumer outputConsumer;
        JazzScmCommand createChangesetCmd;
        int status;
        if (scmVersion != null && StringUtils.isNotEmpty((String)scmVersion.getName())) {
            throw new ScmException("This provider command can't handle tags.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing checkin command...");
        }
        if ((status = (createChangesetCmd = this.createCreateChangesetCommand(repository, fileSet, message)).execute((StreamConsumer)(outputConsumer = new DebugLoggerConsumer(this.getLogger())), errConsumer = new ErrorConsumer(this.getLogger()))) != 0) {
            return new CheckInScmResult(createChangesetCmd.getCommandString(), "Error code for Jazz SCM create changeset command - " + status, errConsumer.getOutput(), false);
        }
        JazzStatusCommand statusCommand = new JazzStatusCommand();
        statusCommand.setLogger(this.getLogger());
        statusCommand.executeStatusCommand(repository, fileSet);
        JazzScmProviderRepository jazzRepo = (JazzScmProviderRepository)repository;
        if (jazzRepo.isPushChangesAndHaveFlowTargets() && StringUtils.isNotEmpty((String)jazzRepo.getWorkItem()) && (changeSetAliases = jazzRepo.getOutgoingChangeSetAliases()) != null && !changeSetAliases.isEmpty()) {
            for (Integer changeSetAlias : changeSetAliases) {
                JazzScmCommand changesetAssociateCmd = this.createChangesetAssociateCommand(repository, changeSetAlias);
                status = changesetAssociateCmd.execute((StreamConsumer)(outputConsumer = new DebugLoggerConsumer(this.getLogger())), errConsumer = new ErrorConsumer(this.getLogger()));
                if (status == 0) continue;
                return new CheckInScmResult(changesetAssociateCmd.getCommandString(), "Error code for Jazz SCM changeset associate command - " + status, errConsumer.getOutput(), false);
            }
        }
        return this.executeCheckInCommand(repository, fileSet, scmVersion);
    }

    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, ScmVersion scmVersion) throws ScmException {
        ErrorConsumer errConsumer;
        DebugLoggerConsumer deliverConsumer;
        JazzScmCommand deliverCmd;
        int status;
        JazzAddCommand addCommand = new JazzAddCommand();
        addCommand.setLogger(this.getLogger());
        AddScmResult addResult = addCommand.executeAddCommand(repo, fileSet);
        JazzScmProviderRepository jazzRepo = (JazzScmProviderRepository)repo;
        if (jazzRepo.isPushChangesAndHaveFlowTargets() && (status = (deliverCmd = this.createDeliverCommand((JazzScmProviderRepository)repo, fileSet)).execute((StreamConsumer)(deliverConsumer = new DebugLoggerConsumer(this.getLogger())), errConsumer = new ErrorConsumer(this.getLogger()))) != 0) {
            return new CheckInScmResult(deliverCmd.getCommandString(), "Error code for Jazz SCM deliver command - " + status, errConsumer.getOutput(), false);
        }
        return new CheckInScmResult(addResult.getCommandLine(), addResult.getAddedFiles());
    }

    public JazzScmCommand createCreateChangesetCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message) {
        JazzScmCommand command = new JazzScmCommand("create", "changeset", repo, false, fileSet, this.getLogger());
        command.addArgument(message);
        return command;
    }

    public JazzScmCommand createChangesetAssociateCommand(ScmProviderRepository repo, Integer changeSetAlias) {
        JazzScmCommand command = new JazzScmCommand("changeset", "associate", repo, false, null, this.getLogger());
        JazzScmProviderRepository jazzRepo = (JazzScmProviderRepository)repo;
        command.addArgument(StringUtils.leftPad((String)changeSetAlias.toString(), (int)4, (String)"0"));
        command.addArgument(jazzRepo.getWorkItem());
        return command;
    }

    public JazzScmCommand createCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet) {
        JazzScmCommand command = new JazzScmCommand("checkin", null, repo, false, fileSet, this.getLogger());
        List files = fileSet.getFileList();
        if (files != null && !files.isEmpty()) {
            for (File file : files) {
                command.addArgument(file.getPath());
            }
        } else {
            command.addArgument(".");
        }
        return command;
    }

    public JazzScmCommand createDeliverCommand(JazzScmProviderRepository repo, ScmFileSet fileSet) {
        JazzScmCommand command = new JazzScmCommand("deliver", (ScmProviderRepository)repo, fileSet, this.getLogger());
        if (repo.getWorkspace() != null && !repo.getWorkspace().equals("")) {
            command.addArgument("--source");
            command.addArgument(repo.getWorkspace());
        }
        if (repo.getFlowTarget() != null && !repo.getFlowTarget().equals("")) {
            command.addArgument("--target");
            command.addArgument(repo.getFlowTarget());
        }
        command.addArgument("--overwrite-uncommitted");
        return command;
    }
}

