/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.classes;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.DescendingVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.classes.ImportVisitor;
import org.apache.maven.shared.jar.classes.JarClasses;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class JarClassesAnalysis
extends AbstractLogEnabled {
    private static final double JAVA_1_6_CLASS_VERSION = 50.0;
    private static final double JAVA_1_5_CLASS_VERSION = 49.0;
    private static final double JAVA_1_4_CLASS_VERSION = 47.0;
    private static final double JAVA_1_3_CLASS_VERSION = 46.0;
    private static final double JAVA_1_2_CLASS_VERSION = 45.65536;
    private static final double JAVA_1_1_CLASS_VERSION = 45.3;

    public JarClasses analyze(JarAnalyzer jarAnalyzer) {
        JarClasses classes = jarAnalyzer.getJarData().getJarClasses();
        if (classes == null) {
            String jarfilename = jarAnalyzer.getFile().getAbsolutePath();
            classes = new JarClasses();
            List classList = jarAnalyzer.getClassEntries();
            classes.setDebugPresent(false);
            double maxVersion = 0.0;
            Iterator it = classList.iterator();
            while (it.hasNext()) {
                JarEntry entry = (JarEntry)it.next();
                String classname = entry.getName();
                try {
                    ClassParser classParser = new ClassParser(jarfilename, classname);
                    JavaClass javaClass = classParser.parse();
                    String classSignature = javaClass.getClassName();
                    if (!classes.isDebugPresent() && this.hasDebugSymbols(javaClass)) {
                        classes.setDebugPresent(true);
                    }
                    double classVersion = javaClass.getMajor();
                    if (javaClass.getMinor() > 0) {
                        classVersion += 1.0 / (double)javaClass.getMinor();
                    }
                    if (classVersion > maxVersion) {
                        maxVersion = classVersion;
                    }
                    Method[] methods = javaClass.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        classes.addMethod(classSignature + "." + methods[i].getName() + methods[i].getSignature());
                    }
                    String classPackageName = javaClass.getPackageName();
                    classes.addClassName(classSignature);
                    classes.addPackage(classPackageName);
                    ImportVisitor importVisitor = new ImportVisitor(javaClass);
                    DescendingVisitor descVisitor = new DescendingVisitor(javaClass, (Visitor)importVisitor);
                    javaClass.accept((Visitor)descVisitor);
                    classes.addImports(importVisitor.getImports());
                }
                catch (ClassFormatException e) {
                    this.getLogger().warn("Unable to process class " + classname + " in JarAnalyzer File " + jarfilename, (Throwable)e);
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to process JarAnalyzer File " + jarfilename, (Throwable)e);
                }
            }
            if (maxVersion >= 50.0) {
                classes.setJdkRevision("1.6");
            } else if (maxVersion >= 49.0) {
                classes.setJdkRevision("1.5");
            } else if (maxVersion > 47.0) {
                classes.setJdkRevision("1.4");
            } else if (maxVersion > 46.0) {
                classes.setJdkRevision("1.3");
            } else if (maxVersion > 45.65536) {
                classes.setJdkRevision("1.2");
            } else if (maxVersion > 45.3) {
                classes.setJdkRevision("1.1");
            } else if (maxVersion > 0.0) {
                classes.setJdkRevision("1.0");
            }
            jarAnalyzer.getJarData().setJarClasses(classes);
        }
        return classes;
    }

    private boolean hasDebugSymbols(JavaClass javaClass) {
        boolean ret = false;
        Method[] methods = javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            LineNumberTable linenumbers = methods[i].getLineNumberTable();
            if (linenumbers == null || linenumbers.getLength() <= 0) continue;
            ret = true;
            break;
        }
        return ret;
    }
}

