/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.oozie.fluentjob.api.factory.WorkflowFactory;

class ApiJarFactory {
    private final File classFolder;
    private final File jarFolder;
    private final String apiJarName;
    private final Class<? extends WorkflowFactory> apiFactoryClass;

    ApiJarFactory(File classFolder, File jarFolder, Class<? extends WorkflowFactory> apiFactoryClass, String apiJarName) {
        Preconditions.checkNotNull((Object)classFolder, (Object)"classFolder should be set");
        Preconditions.checkNotNull((Object)jarFolder, (Object)"jarFolder should be set");
        Preconditions.checkNotNull((Object)apiJarName, (Object)"apiJarName should be set");
        Preconditions.checkNotNull(apiFactoryClass, (Object)"apiFactoryClass should be set");
        Preconditions.checkState((boolean)WorkflowFactory.class.isAssignableFrom(apiFactoryClass), (Object)String.format("%s should be a %s", apiFactoryClass.getName(), WorkflowFactory.class.getName()));
        this.classFolder = classFolder;
        this.jarFolder = jarFolder;
        this.apiJarName = apiJarName;
        this.apiFactoryClass = apiFactoryClass;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "WEAK_FILENAMEUTILS"}, justification="FilenameUtils is used to filter user output. JDK8+ is used.")
    JarFile create() throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, this.apiFactoryClass.getName());
        String apiJarPath = this.jarFolder + File.separator + FilenameUtils.getName((String)this.apiJarName);
        try (JarOutputStream target = new JarOutputStream((OutputStream)new FileOutputStream(FilenameUtils.getFullPath((String)apiJarPath) + FilenameUtils.getName((String)apiJarPath)), manifest);){
            this.addWorkflowJarEntry(this.classFolder, target);
        }
        return new JarFile(apiJarPath);
    }

    private void addWorkflowJarEntry(File source, JarOutputStream target) throws IOException {
        if (source.isDirectory()) {
            File[] nestedFiles;
            String name = source.getPath().replace("\\", "/");
            if (!name.isEmpty()) {
                if (!name.endsWith("/")) {
                    name = name + "/";
                }
                JarEntry entry = new JarEntry(name);
                entry.setTime(source.lastModified());
                target.putNextEntry(entry);
                target.closeEntry();
            }
            if ((nestedFiles = source.listFiles()) == null) {
                return;
            }
            for (File nestedFile : nestedFiles) {
                this.addWorkflowJarEntry(nestedFile, target);
            }
            return;
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
            JarEntry entry = new JarEntry(source.getPath().replace("\\", "/"));
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            IOUtils.copy((InputStream)in, (OutputStream)target);
            target.closeEntry();
        }
    }
}

