/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.oozie.fluentjob.api.factory.WorkflowFactory;
import org.apache.oozie.fluentjob.api.workflow.Workflow;

public class ApiJarLoader {
    private final File apiJarFile;

    public ApiJarLoader(File apiJarFile) {
        Preconditions.checkArgument((boolean)apiJarFile.isFile(), (String)"Fluent Job API JAR [%s] should be a file", (Object[])new Object[]{apiJarFile.toString()});
        Preconditions.checkArgument((boolean)apiJarFile.getName().endsWith(".jar"), (String)"Fluent Job API JAR [%s] should be a JAR file", (Object[])new Object[]{apiJarFile.toString()});
        this.apiJarFile = apiJarFile;
    }

    public Workflow loadAndGenerate() throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        String mainClassName = this.getMainClassName();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)mainClassName) ? 1 : 0) != 0, (Object)"Fluent Job API JAR should have a Main-Class defined in MANIFEST.MF");
        URLClassLoader workflowFactoryClassLoader = URLClassLoader.newInstance(new URL[]{this.apiJarFile.toURI().toURL()});
        Class<?> mainClass = workflowFactoryClassLoader.loadClass(mainClassName);
        Preconditions.checkNotNull(mainClass, (Object)"Fluent Job API JAR file should have a main class");
        Preconditions.checkState((boolean)WorkflowFactory.class.isAssignableFrom(mainClass), (Object)("Fluent Job API JAR main class should be an " + WorkflowFactory.class.getName()));
        Method mainMethod = mainClass.getMethod("create", new Class[0]);
        Preconditions.checkState((boolean)Workflow.class.isAssignableFrom(mainMethod.getReturnType()), (Object)("Fluent Job API JAR file's main class's create() method should return a " + Workflow.class.getName()));
        return (Workflow)mainMethod.invoke(mainClass.newInstance(), new Object[0]);
    }

    private String getMainClassName() throws IOException {
        try (JarFile apiJar = new JarFile(this.apiJarFile);){
            Preconditions.checkNotNull((Object)apiJar.getManifest(), (Object)"Fluent Job API JAR doesn't have MANIFEST.MF");
            String string = apiJar.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            return string;
        }
    }
}

