/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;

public final class Decrypt {
    private static final String ALIAS = "-alias";
    private static final String PASSWORD = "-password";
    private static final String KEYSTORE = "-keyStore";
    private String password;
    private String infile;
    private String outfile;
    private String alias;
    private String keyStore;

    private Decrypt() {
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        Decrypt decrypt = new Decrypt();
        decrypt.parseCommandLineArgs(args);
        decrypt.decrypt();
    }

    private void parseCommandLineArgs(String[] args) {
        if (args.length < 1 || args.length > 8) {
            Decrypt.usage();
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals(ALIAS)) {
                    if (++i >= args.length) {
                        Decrypt.usage();
                    }
                    this.alias = args[i];
                    continue;
                }
                if (args[i].equals(KEYSTORE)) {
                    if (++i >= args.length) {
                        Decrypt.usage();
                    }
                    this.keyStore = args[i];
                    continue;
                }
                if (args[i].equals(PASSWORD)) {
                    if (++i >= args.length) {
                        Decrypt.usage();
                    }
                    this.password = args[i];
                    continue;
                }
                if (this.infile == null) {
                    this.infile = args[i];
                    continue;
                }
                if (this.outfile == null) {
                    this.outfile = args[i];
                    continue;
                }
                Decrypt.usage();
            }
            if (this.infile == null) {
                Decrypt.usage();
            }
            if (this.outfile == null) {
                this.outfile = this.infile;
            }
            if (this.password == null) {
                this.password = "";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decrypt() throws IOException {
        PDDocument document = null;
        try {
            FileInputStream keyStoreStream = null;
            if (this.keyStore != null) {
                keyStoreStream = new FileInputStream(this.keyStore);
            }
            if ((document = PDDocument.load((File)new File(this.infile), (String)this.password, (InputStream)keyStoreStream, (String)this.alias)).isEncrypted()) {
                AccessPermission ap = document.getCurrentAccessPermission();
                if (!ap.isOwnerPermission()) throw new IOException("Error: You are only allowed to decrypt a document with the owner password.");
                document.setAllSecurityToBeRemoved(true);
                document.save(this.outfile);
                return;
            } else {
                System.err.println("Error: Document is not encrypted.");
            }
            return;
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar Decrypt [options] <inputfile> [outputfile]\n\nOptions:\n  -alias    : The alias of the key in the certificate file (mandatory if several keys are available\n  -password : The password to open the certificate and extract the private key from it.\n  -keyStore : The KeyStore that holds the certificate.";
        System.err.println(message);
        System.exit(1);
    }
}

