/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.parser.api;

import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.apache.shardingsphere.distsql.parser.core.DistSQLParserFactory;
import org.apache.shardingsphere.distsql.parser.core.DistSQLVisitor;
import org.apache.shardingsphere.sql.parser.api.parser.SQLParser;
import org.apache.shardingsphere.sql.parser.core.parser.ParseASTNode;
import org.apache.shardingsphere.sql.parser.exception.SQLParsingException;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class DistSQLStatementParserEngine {
    public SQLStatement parse(String sql) {
        ParseASTNode parseASTNode = this.twoPhaseParse(sql);
        if (parseASTNode.getRootNode() instanceof ErrorNode) {
            throw new SQLParsingException("Unsupported SQL of `%s`", new Object[]{sql});
        }
        return (SQLStatement)new DistSQLVisitor().visit(parseASTNode.getRootNode());
    }

    private ParseASTNode twoPhaseParse(String sql) {
        SQLParser sqlParser = DistSQLParserFactory.newInstance(sql);
        try {
            this.setPredictionMode((Parser)sqlParser, PredictionMode.SLL);
            return (ParseASTNode)sqlParser.parse();
        }
        catch (ParseCancellationException ex) {
            ((Parser)sqlParser).reset();
            this.setPredictionMode((Parser)sqlParser, PredictionMode.LL);
            return (ParseASTNode)sqlParser.parse();
        }
    }

    private void setPredictionMode(Parser sqlParser, PredictionMode mode) {
        sqlParser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        ((ParserATNSimulator)sqlParser.getInterpreter()).setPredictionMode(mode);
    }
}

