/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.rewrite.parameter.EncryptParameterRewriter;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.QueryAssistedEncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.segment.insert.values.InsertValueContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptInsertValueParameterRewriter
extends EncryptParameterRewriter<InsertStatementContext> {
    @Override
    protected boolean isNeedRewriteForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && !InsertStatementHandler.getSetAssignmentSegment((InsertStatement)((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement())).isPresent();
    }

    public void rewrite(ParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, List<Object> parameters) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        Iterator descendingColumnNames = insertStatementContext.getDescendingColumnNames();
        while (descendingColumnNames.hasNext()) {
            String columnName = (String)descendingColumnNames.next();
            this.getEncryptRule().findEncryptor(tableName, columnName).ifPresent(encryptAlgorithm -> this.encryptInsertValues((GroupedParameterBuilder)parameterBuilder, insertStatementContext, (EncryptAlgorithm)encryptAlgorithm, tableName, columnName));
        }
    }

    private void encryptInsertValues(GroupedParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, EncryptAlgorithm encryptAlgorithm, String tableName, String encryptLogicColumnName) {
        int columnIndex = this.getColumnIndex(parameterBuilder, insertStatementContext, encryptLogicColumnName);
        int count = 0;
        for (List each : insertStatementContext.getGroupedParameters()) {
            int parameterIndex = ((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getParameterIndex(columnIndex);
            if (!each.isEmpty()) {
                StandardParameterBuilder standardParameterBuilder = (StandardParameterBuilder)parameterBuilder.getParameterBuilders().get(count);
                ExpressionSegment expressionSegment = (ExpressionSegment)((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getValueExpressions().get(columnIndex);
                if (expressionSegment instanceof ParameterMarkerExpressionSegment) {
                    this.encryptInsertValue(encryptAlgorithm, tableName, parameterIndex, ((InsertValueContext)insertStatementContext.getInsertValueContexts().get(count)).getValue(columnIndex), standardParameterBuilder, encryptLogicColumnName);
                }
            }
            ++count;
        }
    }

    private int getColumnIndex(GroupedParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, String encryptLogicColumnName) {
        ArrayList columnNames;
        if (parameterBuilder.getDerivedColumnName().isPresent()) {
            columnNames = new ArrayList(insertStatementContext.getColumnNames());
            columnNames.remove(parameterBuilder.getDerivedColumnName().get());
        } else {
            columnNames = insertStatementContext.getColumnNames();
        }
        return columnNames.indexOf(encryptLogicColumnName);
    }

    private void encryptInsertValue(EncryptAlgorithm encryptAlgorithm, String tableName, int parameterIndex, Object originalValue, StandardParameterBuilder parameterBuilder, String encryptLogicColumnName) {
        parameterBuilder.addReplacedParameters(parameterIndex, (Object)encryptAlgorithm.encrypt(originalValue));
        LinkedList<Object> addedParameters = new LinkedList<Object>();
        if (encryptAlgorithm instanceof QueryAssistedEncryptAlgorithm) {
            Optional assistedColumnName = this.getEncryptRule().findAssistedQueryColumn(tableName, encryptLogicColumnName);
            Preconditions.checkArgument((boolean)assistedColumnName.isPresent(), (Object)"Can not find assisted query Column Name");
            addedParameters.add(((QueryAssistedEncryptAlgorithm)encryptAlgorithm).queryAssistedEncrypt(originalValue.toString()));
        }
        if (this.getEncryptRule().findPlainColumn(tableName, encryptLogicColumnName).isPresent()) {
            addedParameters.add(originalValue);
        }
        if (!addedParameters.isEmpty()) {
            if (!parameterBuilder.getAddedIndexAndParameters().containsKey(parameterIndex + 1)) {
                parameterBuilder.getAddedIndexAndParameters().put(parameterIndex + 1, new LinkedList());
            }
            ((Collection)parameterBuilder.getAddedIndexAndParameters().get(parameterIndex + 1)).addAll(addedParameters);
        }
    }
}

