/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;

public final class EncryptProjectionTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator<SelectStatementContext>,
QueryWithCipherColumnAware {
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && !((SelectStatementContext)sqlStatementContext).getSimpleTableSegments().isEmpty();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SelectStatementContext selectStatementContext) {
        ProjectionsSegment projectionsSegment = ((SelectStatement)selectStatementContext.getSqlStatement()).getProjections();
        String tableName = ((SimpleTableSegment)selectStatementContext.getSimpleTableSegments().iterator().next()).getTableName().getIdentifier().getValue();
        return this.getEncryptRule().findEncryptTable(tableName).map(encryptTable -> this.generateSQLTokens(projectionsSegment, tableName, selectStatementContext, (EncryptTable)encryptTable)).orElseGet(Collections::emptyList);
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(ProjectionsSegment segment, String tableName, SelectStatementContext selectStatementContext, EncryptTable encryptTable) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (ProjectionSegment each : segment.getProjections()) {
            ShorthandProjection shorthandProjection;
            if (each instanceof ColumnProjectionSegment && encryptTable.getLogicColumns().contains(((ColumnProjectionSegment)each).getColumn().getIdentifier().getValue())) {
                result.add(this.generateSQLToken((ColumnProjectionSegment)each, tableName));
            }
            if (!this.isToGeneratedSQLToken(each, selectStatementContext, tableName) || (shorthandProjection = this.getShorthandProjection((ShorthandProjectionSegment)each, selectStatementContext.getProjectionsContext())).getActualColumns().isEmpty()) continue;
            result.add(this.generateSQLToken((ShorthandProjectionSegment)each, shorthandProjection, tableName, encryptTable));
        }
        return result;
    }

    private boolean isToGeneratedSQLToken(ProjectionSegment projectionSegment, SelectStatementContext selectStatementContext, String tableName) {
        if (!(projectionSegment instanceof ShorthandProjectionSegment)) {
            return false;
        }
        Optional ownerSegment = ((ShorthandProjectionSegment)projectionSegment).getOwner();
        return ownerSegment.map(segment -> selectStatementContext.getTablesContext().findTableNameFromSQL(segment.getIdentifier().getValue()).equalsIgnoreCase(tableName)).orElse(true);
    }

    private SubstitutableColumnNameToken generateSQLToken(ColumnProjectionSegment segment, String tableName) {
        String encryptColumnName = this.getEncryptColumnName(tableName, segment.getColumn().getIdentifier().getValue());
        if (!segment.getAlias().isPresent()) {
            encryptColumnName = encryptColumnName + " AS " + segment.getColumn().getIdentifier().getValue();
        }
        return segment.getColumn().getOwner().isPresent() ? new SubstitutableColumnNameToken(((OwnerSegment)segment.getColumn().getOwner().get()).getStopIndex() + 2, segment.getStopIndex(), encryptColumnName) : new SubstitutableColumnNameToken(segment.getStartIndex(), segment.getStopIndex(), encryptColumnName);
    }

    private SubstitutableColumnNameToken generateSQLToken(ShorthandProjectionSegment segment, ShorthandProjection shorthandProjection, String tableName, EncryptTable encryptTable) {
        LinkedList<String> shorthandExtensionProjections = new LinkedList<String>();
        for (ColumnProjection each : shorthandProjection.getActualColumns()) {
            if (encryptTable.getLogicColumns().contains(each.getName())) {
                shorthandExtensionProjections.add(new ColumnProjection(each.getOwner(), this.getEncryptColumnName(tableName, each.getName()), each.getName()).getExpressionWithAlias());
                continue;
            }
            shorthandExtensionProjections.add(each.getExpression());
        }
        return new SubstitutableColumnNameToken(segment.getStartIndex(), segment.getStopIndex(), Joiner.on((String)", ").join(shorthandExtensionProjections));
    }

    private String getEncryptColumnName(String tableName, String logicEncryptColumnName) {
        Optional plainColumn = this.getEncryptRule().findPlainColumn(tableName, logicEncryptColumnName);
        return plainColumn.isPresent() && !this.queryWithCipherColumn ? (String)plainColumn.get() : this.getEncryptRule().getCipherColumn(tableName, logicEncryptColumnName);
    }

    private ShorthandProjection getShorthandProjection(ShorthandProjectionSegment segment, ProjectionsContext projectionsContext) {
        Optional owner = segment.getOwner().isPresent() ? Optional.of(((OwnerSegment)segment.getOwner().get()).getIdentifier().getValue()) : Optional.empty();
        for (Projection each : projectionsContext.getProjections()) {
            if (!(each instanceof ShorthandProjection)) continue;
            if (!owner.isPresent() && !((ShorthandProjection)each).getOwner().isPresent()) {
                return (ShorthandProjection)each;
            }
            if (!owner.isPresent() || !((String)owner.get()).equals(((ShorthandProjection)each).getOwner().orElse(null))) continue;
            return (ShorthandProjection)each;
        }
        throw new IllegalStateException(String.format("Can not find shorthand projection segment, owner is: `%s`", owner.orElse(null)));
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

