/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.table;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;

public final class TablesContext {
    private final Collection<SimpleTableSegment> originalTables = new LinkedList<SimpleTableSegment>();
    private final Map<String, SimpleTableSegment> uniqueTables = new HashMap<String, SimpleTableSegment>();
    private final Collection<String> schemaNames = new HashSet<String>();

    public TablesContext(SimpleTableSegment tableSegment) {
        this(null == tableSegment ? Collections.emptyList() : Collections.singletonList(tableSegment));
    }

    public TablesContext(Collection<SimpleTableSegment> tableSegments) {
        if (tableSegments.isEmpty()) {
            return;
        }
        for (SimpleTableSegment each : tableSegments) {
            this.originalTables.add(each);
            this.uniqueTables.putIfAbsent(each.getTableName().getIdentifier().getValue(), each);
            each.getOwner().ifPresent(optional -> this.schemaNames.add(optional.getIdentifier().getValue()));
        }
    }

    public Collection<String> getTableNames() {
        return this.uniqueTables.keySet();
    }

    public Collection<SimpleTableSegment> getAllUniqueTables() {
        return this.uniqueTables.values();
    }

    public Map<String, String> findTableName(Collection<ColumnSegment> columns, ShardingSphereSchema schema) {
        if (1 == this.uniqueTables.size()) {
            String tableName = this.uniqueTables.keySet().iterator().next();
            return columns.stream().collect(Collectors.toMap(ColumnSegment::getQualifiedName, each -> tableName, (oldValue, currentValue) -> oldValue));
        }
        HashMap<String, String> result = new HashMap<String, String>(columns.size(), 1.0f);
        Map ownerColumns = columns.stream().filter(each -> each.getOwner().isPresent()).collect(Collectors.groupingBy(each -> each.getOwner().map(optional -> optional.getIdentifier().getValue()).orElse(null), () -> new TreeMap(String.CASE_INSENSITIVE_ORDER), Collectors.toList()));
        result.putAll(this.findTableNameFromSQL(ownerColumns));
        Collection columnNames = columns.stream().filter(each -> !each.getOwner().isPresent()).map(each -> each.getIdentifier().getValue()).collect(Collectors.toSet());
        result.putAll(this.findTableNameFromMetaData(columnNames, schema));
        return result;
    }

    public Optional<String> findTableName(ColumnProjection column, ShardingSphereSchema schema) {
        if (1 == this.uniqueTables.size()) {
            return Optional.of(this.uniqueTables.keySet().iterator().next());
        }
        if (null != column.getOwner()) {
            return this.findTableNameFromSQL(column.getOwner());
        }
        return this.findTableNameFromMetaData(column.getName(), schema);
    }

    public Optional<String> findTableNameFromSQL(String tableNameOrAlias) {
        for (String each : this.uniqueTables.keySet()) {
            if (!tableNameOrAlias.equalsIgnoreCase(each) && !tableNameOrAlias.equalsIgnoreCase(this.uniqueTables.get(each).getAlias().orElse(null))) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    private Map<String, String> findTableNameFromSQL(Map<String, List<ColumnSegment>> ownerColumns) {
        if (ownerColumns.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String each : this.uniqueTables.keySet()) {
            Optional alias;
            if (ownerColumns.containsKey(each)) {
                ownerColumns.get(each).stream().map(ColumnSegment::getQualifiedName).forEach(column -> result.put((String)column, each));
            }
            if (!(alias = this.uniqueTables.get(each).getAlias()).isPresent() || !ownerColumns.containsKey(alias.get())) continue;
            ownerColumns.get(alias.get()).stream().map(ColumnSegment::getQualifiedName).forEach(column -> result.put((String)column, each));
        }
        return result;
    }

    private Map<String, String> findTableNameFromMetaData(Collection<String> columnNames, ShardingSphereSchema schema) {
        if (columnNames.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String each : this.uniqueTables.keySet()) {
            List tableColumnNames = schema.getAllColumnNames(each);
            if (tableColumnNames.isEmpty()) continue;
            Collection intersectionColumnNames = tableColumnNames.stream().filter(columnNames::contains).collect(Collectors.toList());
            for (String columnName : intersectionColumnNames) {
                result.put(columnName, each);
            }
        }
        return result;
    }

    private Optional<String> findTableNameFromMetaData(String columnName, ShardingSphereSchema schema) {
        for (String each : this.uniqueTables.keySet()) {
            if (!schema.containsColumn(each, columnName)) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public Optional<String> getSchemaName() {
        Preconditions.checkState((this.schemaNames.size() <= 1 ? 1 : 0) != 0, (Object)"Can not support multiple different schema.");
        return this.schemaNames.stream().findFirst();
    }

    @Generated
    public Collection<SimpleTableSegment> getOriginalTables() {
        return this.originalTables;
    }

    @Generated
    public Map<String, SimpleTableSegment> getUniqueTables() {
        return this.uniqueTables;
    }

    @Generated
    public Collection<String> getSchemaNames() {
        return this.schemaNames;
    }

    @Generated
    public String toString() {
        return "TablesContext(originalTables=" + this.getOriginalTables() + ", uniqueTables=" + this.getUniqueTables() + ", schemaNames=" + this.getSchemaNames() + ")";
    }
}

