/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;

public final class ShorthandProjection
implements Projection {
    private final String owner;
    private final Map<String, ColumnProjection> actualColumns = new LinkedHashMap<String, ColumnProjection>();

    public ShorthandProjection(String owner, Collection<ColumnProjection> columnProjections) {
        this.owner = owner;
        columnProjections.forEach(each -> this.actualColumns.put(each.getExpression().toLowerCase(), (ColumnProjection)each));
    }

    @Override
    public String getExpression() {
        return Strings.isNullOrEmpty((String)this.owner) ? "*" : this.owner + ".*";
    }

    @Override
    public Optional<String> getAlias() {
        return Optional.empty();
    }

    @Override
    public String getColumnLabel() {
        return "*";
    }

    public Optional<String> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    @Generated
    public Map<String, ColumnProjection> getActualColumns() {
        return this.actualColumns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShorthandProjection)) {
            return false;
        }
        ShorthandProjection other = (ShorthandProjection)o;
        Optional<String> this$owner = this.getOwner();
        Optional<String> other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Map<String, ColumnProjection> this$actualColumns = this.getActualColumns();
        Map<String, ColumnProjection> other$actualColumns = other.getActualColumns();
        return !(this$actualColumns == null ? other$actualColumns != null : !((Object)this$actualColumns).equals(other$actualColumns));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Map<String, ColumnProjection> $actualColumns = this.getActualColumns();
        result = result * 59 + ($actualColumns == null ? 43 : ((Object)$actualColumns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ShorthandProjection(owner=" + this.getOwner() + ", actualColumns=" + this.getActualColumns() + ")";
    }
}

