/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.auth.yaml.swapper;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Collections;
import org.apache.shardingsphere.infra.auth.ProxyUser;
import org.apache.shardingsphere.infra.auth.yaml.config.YamlProxyUserConfiguration;
import org.apache.shardingsphere.infra.yaml.swapper.YamlSwapper;

public final class ProxyUserYamlSwapper
implements YamlSwapper<YamlProxyUserConfiguration, ProxyUser> {
    @Override
    public YamlProxyUserConfiguration swapToYamlConfiguration(ProxyUser data) {
        YamlProxyUserConfiguration result = new YamlProxyUserConfiguration();
        result.setPassword(data.getPassword());
        String authorizedSchemas = null == data.getAuthorizedSchemas() ? "" : Joiner.on((char)',').join(data.getAuthorizedSchemas());
        result.setAuthorizedSchemas(authorizedSchemas);
        return result;
    }

    @Override
    public ProxyUser swapToObject(YamlProxyUserConfiguration yamlConfig) {
        if (Strings.isNullOrEmpty((String)yamlConfig.getAuthorizedSchemas())) {
            return new ProxyUser(yamlConfig.getPassword(), Collections.emptyList());
        }
        return new ProxyUser(yamlConfig.getPassword(), Splitter.on((char)',').trimResults().splitToList((CharSequence)yamlConfig.getAuthorizedSchemas()));
    }
}

