/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.datasource;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.datasource.JDBCParameterDecorator;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;

public final class DataSourceConfiguration {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";
    private static final Collection<Class<?>> GENERAL_CLASS_TYPE;
    private static final Collection<String> SKIPPED_PROPERTY_NAMES;
    private final String dataSourceClassName;
    private final Map<String, Object> props = new LinkedHashMap<String, Object>();

    public static DataSourceConfiguration getDataSourceConfiguration(DataSource dataSource) {
        DataSourceConfiguration result = new DataSourceConfiguration(dataSource.getClass().getName());
        result.props.putAll(DataSourceConfiguration.findAllGetterProperties(dataSource));
        return result;
    }

    private static Map<String, Object> findAllGetterProperties(Object target) {
        Collection<Method> allGetterMethods = DataSourceConfiguration.findAllGetterMethods(target.getClass());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(allGetterMethods.size(), 1.0f);
        for (Method each : allGetterMethods) {
            String propertyName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, each.getName().substring(GETTER_PREFIX.length()));
            if (!GENERAL_CLASS_TYPE.contains(each.getReturnType()) || SKIPPED_PROPERTY_NAMES.contains(propertyName)) continue;
            result.put(propertyName, each.invoke(target, new Object[0]));
        }
        return result;
    }

    private static Collection<Method> findAllGetterMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        HashSet<Method> result = new HashSet<Method>(methods.length);
        for (Method each : methods) {
            if (!each.getName().startsWith(GETTER_PREFIX) || 0 != each.getParameterTypes().length) continue;
            result.add(each);
        }
        return result;
    }

    public DataSource createDataSource() {
        DataSource result = (DataSource)Class.forName(this.dataSourceClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        Method[] methods = result.getClass().getMethods();
        for (Map.Entry<String, Object> entry : this.props.entrySet()) {
            Optional<Method> setterMethod;
            if (SKIPPED_PROPERTY_NAMES.contains(entry.getKey()) || !(setterMethod = this.findSetterMethod(methods, entry.getKey())).isPresent()) continue;
            setterMethod.get().invoke((Object)result, entry.getValue());
        }
        Optional<JDBCParameterDecorator> decorator = this.findJDBCParameterDecorator(result);
        return decorator.isPresent() ? decorator.get().decorate(result) : result;
    }

    private Optional<JDBCParameterDecorator> findJDBCParameterDecorator(DataSource dataSource) {
        return ShardingSphereServiceLoader.newServiceInstances(JDBCParameterDecorator.class).stream().filter(each -> each.getType() == dataSource.getClass()).findFirst();
    }

    private Optional<Method> findSetterMethod(Method[] methods, String property) {
        String setterMethodName = Joiner.on((String)"").join((Object)SETTER_PREFIX, (Object)CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property), new Object[0]);
        for (Method each : methods) {
            if (!each.getName().equals(setterMethodName) || 1 != each.getParameterTypes().length) continue;
            return Optional.of(each);
        }
        return Optional.empty();
    }

    public void addPropertySynonym(String originalName, String synonym) {
        if (this.props.containsKey(originalName)) {
            this.props.put(synonym, this.props.get(originalName));
        }
        if (this.props.containsKey(synonym)) {
            this.props.put(originalName, this.props.get(synonym));
        }
    }

    public boolean equals(Object obj) {
        return this == obj || null != obj && this.getClass() == obj.getClass() && this.equalsByProperties((DataSourceConfiguration)obj);
    }

    private boolean equalsByProperties(DataSourceConfiguration dataSourceConfig) {
        if (!this.dataSourceClassName.equals(dataSourceConfig.dataSourceClassName)) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.props.entrySet()) {
            if (!dataSourceConfig.props.containsKey(entry.getKey()) || String.valueOf(entry.getValue()).equals(String.valueOf(dataSourceConfig.props.get(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.props.entrySet()) {
            stringBuilder.append(entry.getKey()).append(entry.getValue());
        }
        return Objects.hashCode((Object[])new Object[]{this.dataSourceClassName, stringBuilder.toString()});
    }

    @Generated
    public DataSourceConfiguration(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    @Generated
    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    @Generated
    public Map<String, Object> getProps() {
        return this.props;
    }

    static {
        ShardingSphereServiceLoader.register(JDBCParameterDecorator.class);
        GENERAL_CLASS_TYPE = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class, Collection.class, List.class});
        SKIPPED_PROPERTY_NAMES = Sets.newHashSet((Object[])new String[]{"loginTimeout"});
    }
}

