/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.physical.model.table;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.physical.jdbc.MetaDataConnectionAdapter;
import org.apache.shardingsphere.infra.metadata.model.physical.jdbc.handler.DatabaseMetaDataDialectHandlerFactory;
import org.apache.shardingsphere.infra.metadata.model.physical.model.column.PhysicalColumnMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.model.physical.model.index.PhysicalIndexMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;

public final class PhysicalTableMetaDataLoader {
    public static Optional<PhysicalTableMetaData> load(DataSource dataSource, String tableNamePattern, DatabaseType databaseType) throws SQLException {
        try (MetaDataConnectionAdapter connectionAdapter = new MetaDataConnectionAdapter(databaseType, dataSource.getConnection());){
            String formattedTableNamePattern = PhysicalTableMetaDataLoader.formatTableNamePattern(tableNamePattern, databaseType);
            Optional<PhysicalTableMetaData> optional = PhysicalTableMetaDataLoader.isTableExist(connectionAdapter, formattedTableNamePattern) ? Optional.of(new PhysicalTableMetaData(PhysicalColumnMetaDataLoader.load(connectionAdapter, formattedTableNamePattern, databaseType), PhysicalIndexMetaDataLoader.load(connectionAdapter, formattedTableNamePattern))) : Optional.empty();
            return optional;
        }
    }

    private static String formatTableNamePattern(String tableNamePattern, DatabaseType databaseType) {
        return DatabaseMetaDataDialectHandlerFactory.findHandler(databaseType).map(handler -> handler.formatTableNamePattern(tableNamePattern)).orElse(tableNamePattern);
    }

    private static boolean isTableExist(Connection connection, String tableNamePattern) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), tableNamePattern, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Generated
    private PhysicalTableMetaDataLoader() {
    }
}

