/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.refresh.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.infra.metadata.refresh.MetaDataRefreshStrategy;
import org.apache.shardingsphere.infra.metadata.refresh.TableMetaDataLoaderCallback;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropIndexStatementHandler;

public final class DropIndexStatementMetaDataRefreshStrategy
implements MetaDataRefreshStrategy<DropIndexStatement> {
    @Override
    public void refreshMetaData(ShardingSphereMetaData metaData, DatabaseType databaseType, Collection<String> routeDataSourceNames, DropIndexStatement sqlStatement, TableMetaDataLoaderCallback callback) {
        Collection<String> indexNames = this.getIndexNames(sqlStatement);
        Optional simpleTableSegment = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)sqlStatement);
        String tableName = simpleTableSegment.map(tableSegment -> tableSegment.getTableName().getIdentifier().getValue()).orElse("");
        PhysicalTableMetaData tableMetaData = metaData.getSchemaMetaData().getConfiguredSchemaMetaData().get(tableName);
        if (simpleTableSegment.isPresent()) {
            indexNames.forEach(each -> tableMetaData.getIndexes().remove(each));
        }
        for (String each2 : indexNames) {
            if (!this.findLogicTableName(metaData.getSchemaMetaData().getConfiguredSchemaMetaData(), each2).isPresent()) continue;
            tableMetaData.getIndexes().remove(each2);
        }
    }

    private Collection<String> getIndexNames(DropIndexStatement dropIndexStatement) {
        return dropIndexStatement.getIndexes().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toCollection(LinkedList::new));
    }

    private Optional<String> findLogicTableName(PhysicalSchemaMetaData schemaMetaData, String logicIndexName) {
        return schemaMetaData.getAllTableNames().stream().filter(each -> schemaMetaData.get((String)each).getIndexes().containsKey(logicIndexName)).findFirst();
    }
}

