/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi.typed;

import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.exception.ServiceProviderNotFoundException;
import org.apache.shardingsphere.infra.spi.typed.TypedSPI;

public final class TypedSPIRegistry {
    public static <T extends TypedSPI> T getRegisteredService(Class<T> typedSPIClass, String type, Properties props) {
        Optional<TypedSPI> serviceInstance = ShardingSphereServiceLoader.newServiceInstances(typedSPIClass).stream().filter(each -> each.getType().equalsIgnoreCase(type)).findFirst();
        if (serviceInstance.isPresent()) {
            TypedSPI result = serviceInstance.get();
            result.setProps(props);
            return (T)result;
        }
        throw new ServiceProviderNotFoundException(typedSPIClass, type);
    }

    public static <T extends TypedSPI> T getRegisteredService(Class<T> typedSPIClass) {
        Optional<T> serviceInstance = ShardingSphereServiceLoader.newServiceInstances(typedSPIClass).stream().findFirst();
        if (serviceInstance.isPresent()) {
            return (T)((TypedSPI)serviceInstance.get());
        }
        throw new ServiceProviderNotFoundException(typedSPIClass);
    }

    @Generated
    private TypedSPIRegistry() {
    }
}

