/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder.loader.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.DataTypeLoader;
import org.apache.shardingsphere.infra.metadata.schema.builder.spi.DialectTableMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.builder.util.IndexMetaDataUtil;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.IndexMetaData;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class SQLServerTableMetaDataLoader
implements DialectTableMetaDataLoader {
    private static final String TABLE_META_DATA_SQL = "SELECT obj.name AS TABLE_NAME, col.name AS COLUMN_NAME, t.name AS DATA_TYPE, col.collation_name AS COLLATION_NAME, is_identity AS IS_IDENTITY, (SELECT TOP 1 ind.is_primary_key FROM sys.index_columns ic LEFT JOIN sys.indexes ind ON ic.object_id = ind.object_id AND ic.index_id = ind.index_id AND ind.name LIKE 'PK_%' WHERE ic.object_id = obj.object_id AND ic.column_id = col.column_id) AS IS_PRIMARY_KEY FROM sys.objects obj INNER JOIN sys.columns col ON obj.object_id = col.object_id LEFT JOIN sys.types t ON t.user_type_id = col.user_type_id";
    private static final String TABLE_META_DATA_SQL_WITH_EXISTED_TABLES = " WHERE obj.name NOT IN (%s)";
    private static final String INDEX_META_DATA_SQL = "SELECT a.name AS INDEX_NAME, c.name AS TABLE_NAME FROM sys.indexes a JOIN sys.objects c ON a.object_id = c.object_id WHERE a.index_id NOT IN (0, 255) AND c.name IN (%s)";

    @Override
    public Map<String, TableMetaData> load(DataSource dataSource, Collection<String> existedTables) throws SQLException {
        return this.loadTableMetaDataMap(dataSource, existedTables);
    }

    private Map<String, TableMetaData> loadTableMetaDataMap(DataSource dataSource, Collection<String> existedTables) throws SQLException {
        LinkedHashMap<String, TableMetaData> result = new LinkedHashMap<String, TableMetaData>();
        Map<String, Collection<ColumnMetaData>> columnMetaDataMap = this.loadColumnMetaDataMap(dataSource, existedTables);
        if (!columnMetaDataMap.isEmpty()) {
            Map<String, Collection<IndexMetaData>> indexMetaDataMap = this.loadIndexMetaData(dataSource, columnMetaDataMap.keySet());
            for (Map.Entry<String, Collection<ColumnMetaData>> entry : columnMetaDataMap.entrySet()) {
                result.put(entry.getKey(), new TableMetaData(entry.getValue(), indexMetaDataMap.getOrDefault(entry.getKey(), Collections.emptyList())));
            }
        }
        return result;
    }

    private Map<String, Collection<ColumnMetaData>> loadColumnMetaDataMap(DataSource dataSource, Collection<String> existedTables) throws SQLException {
        HashMap<String, Collection<ColumnMetaData>> result = new HashMap<String, Collection<ColumnMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getTableMetaDataSQL(existedTables));){
            Map<String, Integer> dataTypes = DataTypeLoader.load(connection.getMetaData());
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String tableName = resultSet.getString("TABLE_NAME");
                    ColumnMetaData columnMetaData = this.loadColumnMetaData(dataTypes, resultSet);
                    if (!result.containsKey(tableName)) {
                        result.put(tableName, new LinkedList());
                    }
                    ((Collection)result.get(tableName)).add(columnMetaData);
                }
            }
        }
        return result;
    }

    private ColumnMetaData loadColumnMetaData(Map<String, Integer> dataTypeMap, ResultSet resultSet) throws SQLException {
        String columnName = resultSet.getString("COLUMN_NAME");
        String dataType = resultSet.getString("DATA_TYPE");
        String collationName = resultSet.getString("COLLATION_NAME");
        boolean primaryKey = "1".equals(resultSet.getString("IS_PRIMARY_KEY"));
        boolean generated = "1".equals(resultSet.getString("IS_IDENTITY"));
        boolean caseSensitive = null != collationName && collationName.indexOf("_CS") > 0;
        return new ColumnMetaData(columnName, dataTypeMap.get(dataType), primaryKey, generated, caseSensitive);
    }

    private String getTableMetaDataSQL(Collection<String> existedTables) {
        return existedTables.isEmpty() ? TABLE_META_DATA_SQL : TABLE_META_DATA_SQL + String.format(TABLE_META_DATA_SQL_WITH_EXISTED_TABLES, existedTables.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    private Map<String, Collection<IndexMetaData>> loadIndexMetaData(DataSource dataSource, Collection<String> tableNames) throws SQLException {
        HashMap<String, Collection<IndexMetaData>> result = new HashMap<String, Collection<IndexMetaData>>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(this.getIndexMetaDataSQL(tableNames));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String indexName = resultSet.getString("INDEX_NAME");
                String tableName = resultSet.getString("TABLE_NAME");
                if (!result.containsKey(tableName)) {
                    result.put(tableName, new LinkedList());
                }
                ((Collection)result.get(tableName)).add(new IndexMetaData(IndexMetaDataUtil.getLogicIndexName(indexName, tableName)));
            }
        }
        return result;
    }

    private String getIndexMetaDataSQL(Collection<String> tableNames) {
        return String.format(INDEX_META_DATA_SQL, tableNames.stream().map(each -> String.format("'%s'", each)).collect(Collectors.joining(",")));
    }

    @Override
    public String getDatabaseType() {
        return "SQLServer";
    }
}

