/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi.ordered.cache;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPI;
import org.apache.shardingsphere.infra.spi.ordered.cache.CachedOrderedServices;

public final class OrderedServicesCache {
    private static final Map<Class<?>, CachedOrderedServices> CACHED_SERVICES = new ConcurrentHashMap();

    public static <K, V extends OrderedSPI<?>> Optional<CachedOrderedServices> findCachedServices(Collection<K> types, Class<V> orderedSPIClass) {
        return OrderedServicesCache.isHitCache(types, orderedSPIClass) ? Optional.of(CACHED_SERVICES.get(orderedSPIClass)) : Optional.empty();
    }

    private static <K, V extends OrderedSPI<?>> boolean isHitCache(Collection<K> types, Class<V> orderedSPIClass) {
        return CACHED_SERVICES.containsKey(orderedSPIClass) && CACHED_SERVICES.get(orderedSPIClass).getTypes().equals(types);
    }

    public static <K, V extends OrderedSPI<?>> void cacheServices(Collection<K> types, Class<V> orderedSPIClass, Map<K, V> services) {
        CACHED_SERVICES.put(orderedSPIClass, new CachedOrderedServices(types, services));
    }

    @Generated
    private OrderedServicesCache() {
    }
}

