/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.datasource;

import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.config.datasource.InvalidDataSourceConfigurationException;
import org.apache.shardingsphere.infra.distsql.exception.resource.InvalidResourcesException;

public final class DataSourceConfigurationValidator {
    public void validate(Map<String, DataSourceConfiguration> dataSourceConfigs) throws InvalidResourcesException {
        LinkedList<String> errorMessages = new LinkedList<String>();
        for (Map.Entry<String, DataSourceConfiguration> entry : dataSourceConfigs.entrySet()) {
            try {
                this.validate(entry.getKey(), entry.getValue());
            }
            catch (InvalidDataSourceConfigurationException ex) {
                errorMessages.add(ex.getMessage());
            }
        }
        if (!errorMessages.isEmpty()) {
            throw new InvalidResourcesException(errorMessages);
        }
    }

    private void validate(String dataSourceConfigName, DataSourceConfiguration dataSourceConfig) throws InvalidDataSourceConfigurationException {
        DataSource dataSource = null;
        try {
            dataSource = DataSourceConverter.getDataSource(dataSourceConfig);
        }
        catch (Exception ex) {
            throw new InvalidDataSourceConfigurationException(dataSourceConfigName, ex.getMessage());
        }
        finally {
            if (null != dataSource) {
                this.close(dataSource);
            }
        }
    }

    private void close(DataSource dataSource) {
        if (dataSource instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)dataSource)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

