/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.metadata.url;

import java.util.Map;
import java.util.Properties;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;

public final class JdbcUrlAppender {
    public String appendQueryProperties(String jdbcUrl, Properties queryProps) {
        Properties currentQueryProps = DatabaseTypeRegistry.getDatabaseTypeByURL(jdbcUrl).getDataSourceMetaData(jdbcUrl, null).getQueryProperties();
        return this.hasConflictedQueryProperties(currentQueryProps, queryProps) ? this.concat(jdbcUrl.substring(0, jdbcUrl.indexOf(63) + 1), this.getMergedProperties(currentQueryProps, queryProps)) : this.concat(jdbcUrl + (currentQueryProps.isEmpty() ? "?" : "&"), queryProps);
    }

    private boolean hasConflictedQueryProperties(Properties currentQueryProps, Properties toBeAppendedQueryProps) {
        return toBeAppendedQueryProps.keySet().stream().anyMatch(currentQueryProps::containsKey);
    }

    private Properties getMergedProperties(Properties currentQueryProps, Properties toBeAppendedQueryProps) {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)currentQueryProps);
        result.putAll((Map<?, ?>)toBeAppendedQueryProps);
        return result;
    }

    private String concat(String jdbcUrl, Properties queryProps) {
        StringBuilder result = new StringBuilder(jdbcUrl);
        for (Map.Entry<Object, Object> entry : queryProps.entrySet()) {
            result.append(entry.getKey());
            if (null != entry.getValue()) {
                result.append("=").append(entry.getValue());
            }
            result.append("&");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }
}

