/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeBuilder;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.ordered.OrderedSPIRegistry;

public final class DataNodes {
    private final Collection<ShardingSphereRule> rules;
    private final Map<ShardingSphereRule, DataNodeBuilder> decorators;

    public DataNodes(Collection<ShardingSphereRule> rules) {
        this.rules = rules;
        this.decorators = OrderedSPIRegistry.getRegisteredServices(DataNodeBuilder.class, rules);
    }

    public Collection<DataNode> getDataNodes(String tableName) {
        Optional<DataNodeContainedRule> dataNodeContainedRule = this.findDataNodeContainedRule(tableName);
        if (!dataNodeContainedRule.isPresent()) {
            return Collections.emptyList();
        }
        Collection<DataNode> result = new LinkedList<DataNode>(dataNodeContainedRule.get().getAllDataNodes().get(tableName));
        for (Map.Entry<ShardingSphereRule, DataNodeBuilder> entry : this.decorators.entrySet()) {
            result = entry.getValue().build(result, entry.getKey());
        }
        return result;
    }

    private Optional<DataNodeContainedRule> findDataNodeContainedRule(String tableName) {
        return this.rules.stream().filter(each -> this.isDataNodeContainedRuleContainsTable((ShardingSphereRule)each, tableName)).findFirst().map(rule -> (DataNodeContainedRule)rule);
    }

    private boolean isDataNodeContainedRuleContainsTable(ShardingSphereRule each, String tableName) {
        return each instanceof DataNodeContainedRule && ((DataNodeContainedRule)each).getAllDataNodes().containsKey(tableName);
    }

    @Generated
    public DataNodes(Collection<ShardingSphereRule> rules, Map<ShardingSphereRule, DataNodeBuilder> decorators) {
        this.rules = rules;
        this.decorators = decorators;
    }

    static {
        ShardingSphereServiceLoader.register(DataNodeBuilder.class);
    }
}

