/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.creator;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourceReflection;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaData;
import org.apache.shardingsphere.infra.datasource.pool.metadata.DataSourcePoolMetaDataFactory;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.datasource.props.custom.CustomDataSourceProperties;

public final class DataSourcePoolCreator {
    public static Map<String, DataSource> create(Map<String, DataSourceProperties> dataSourcePropsMap) {
        return dataSourcePropsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolCreator.create((DataSourceProperties)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public static DataSource create(DataSourceProperties dataSourceProps) {
        DataSource result = DataSourcePoolCreator.createDataSource(dataSourceProps.getDataSourceClassName());
        Optional<DataSourcePoolMetaData> poolMetaData = DataSourcePoolMetaDataFactory.newInstance(dataSourceProps.getDataSourceClassName());
        DataSourceReflection dataSourceReflection = new DataSourceReflection(result);
        if (poolMetaData.isPresent()) {
            DataSourcePoolCreator.setDefaultFields(dataSourceReflection, poolMetaData.get());
            DataSourcePoolCreator.setConfiguredFields(dataSourceProps, dataSourceReflection, poolMetaData.get());
            DataSourcePoolCreator.appendJdbcUrlProperties(dataSourceProps.getCustomDataSourceProperties(), result, poolMetaData.get());
            dataSourceReflection.addDefaultDataSourceProperties(poolMetaData.get());
        } else {
            DataSourcePoolCreator.setConfiguredFields(dataSourceProps, dataSourceReflection);
        }
        return result;
    }

    private static DataSource createDataSource(String dataSourceClassName) {
        return (DataSource)Class.forName(dataSourceClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static void setDefaultFields(DataSourceReflection dataSourceReflection, DataSourcePoolMetaData<?> poolMetaData) {
        for (Map.Entry<String, Object> entry : poolMetaData.getDefaultProperties().entrySet()) {
            dataSourceReflection.setField(entry.getKey(), entry.getValue());
        }
    }

    private static void setConfiguredFields(DataSourceProperties dataSourceProps, DataSourceReflection dataSourceReflection) {
        for (Map.Entry<String, Object> entry : dataSourceProps.getAllLocalProperties().entrySet()) {
            dataSourceReflection.setField(entry.getKey(), entry.getValue());
        }
    }

    private static void setConfiguredFields(DataSourceProperties dataSourceProps, DataSourceReflection dataSourceReflection, DataSourcePoolMetaData<?> poolMetaData) {
        for (Map.Entry<String, Object> entry : dataSourceProps.getAllLocalProperties().entrySet()) {
            Object fieldValue;
            String fieldName = entry.getKey();
            if (!DataSourcePoolCreator.isValidProperty(fieldName, fieldValue = entry.getValue(), poolMetaData) || fieldName.equals(poolMetaData.getJdbcUrlMetaData().getJdbcUrlPropertiesFieldName())) continue;
            dataSourceReflection.setField(fieldName, fieldValue);
        }
    }

    private static boolean isValidProperty(String key, Object value, DataSourcePoolMetaData<?> poolMetaData) {
        return !poolMetaData.getInvalidProperties().containsKey(key) || null == value || !value.equals(poolMetaData.getInvalidProperties().get(key));
    }

    private static void appendJdbcUrlProperties(CustomDataSourceProperties customDataSourceProps, DataSource targetDataSource, DataSourcePoolMetaData poolMetaData) {
        String jdbcUrlPropertiesFieldName = poolMetaData.getJdbcUrlMetaData().getJdbcUrlPropertiesFieldName();
        if (null != jdbcUrlPropertiesFieldName && customDataSourceProps.getProperties().containsKey(jdbcUrlPropertiesFieldName)) {
            Map jdbcUrlProps = (Map)customDataSourceProps.getProperties().get(jdbcUrlPropertiesFieldName);
            for (Map.Entry entry : jdbcUrlProps.entrySet()) {
                poolMetaData.getJdbcUrlMetaData().appendJdbcUrlProperties((String)entry.getKey(), entry.getValue().toString(), targetDataSource);
            }
        }
    }

    @Generated
    private DataSourcePoolCreator() {
    }
}

