/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datasource.pool.destroyer.impl;

import com.zaxxer.hikari.HikariDataSource;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;

public final class HikariDataSourcePoolDestroyer
implements DataSourcePoolDestroyer {
    @Override
    public void destroy(DataSource dataSource) {
        HikariDataSource hikariDataSource = (HikariDataSource)dataSource;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(() -> {
            while (true) {
                if (null == hikariDataSource.getHikariPoolMXBean() || 0 == hikariDataSource.getHikariPoolMXBean().getActiveConnections()) break;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            hikariDataSource.close();
        });
        executor.shutdown();
    }

    public String getType() {
        return HikariDataSource.class.getName();
    }
}

