/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder.util;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.TableMetaDataLoaderMaterial;

public class TableMetaDataUtil {
    public static Collection<TableMetaDataLoaderMaterial> getTableMetaDataLoadMaterial(Collection<String> tableNames, SchemaBuilderMaterials materials, boolean checkMetaDataEnable) {
        LinkedHashMap<String, Collection<String>> dataSourceTableGroups = new LinkedHashMap<String, Collection<String>>();
        DataNodes dataNodes = new DataNodes(materials.getRules());
        for (String each : tableNames) {
            if (checkMetaDataEnable) {
                TableMetaDataUtil.addAllActualTableDataNode(materials, dataSourceTableGroups, dataNodes, each);
                continue;
            }
            TableMetaDataUtil.addOneActualTableDataNode(materials, dataSourceTableGroups, dataNodes, each);
        }
        return dataSourceTableGroups.entrySet().stream().map(entry -> new TableMetaDataLoaderMaterial((Collection)entry.getValue(), materials.getDataSourceMap().get(entry.getKey()))).collect(Collectors.toList());
    }

    private static void addOneActualTableDataNode(SchemaBuilderMaterials materials, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Optional<DataNode> optional = dataNodes.getDataNodes(table).stream().filter(dataNode -> materials.getDataSourceMap().keySet().contains(dataNode.getDataSourceName())).findFirst();
        String dataSourceName = optional.map(DataNode::getDataSourceName).orElse(materials.getDataSourceMap().keySet().iterator().next());
        String tableName = optional.map(DataNode::getTableName).orElse(table);
        TableMetaDataUtil.addDataSourceTableGroups(dataSourceName, tableName, dataSourceTableGroups);
    }

    private static void addAllActualTableDataNode(SchemaBuilderMaterials materials, Map<String, Collection<String>> dataSourceTableGroups, DataNodes dataNodes, String table) {
        Collection<DataNode> tableDataNodes = dataNodes.getDataNodes(table);
        if (tableDataNodes.isEmpty()) {
            TableMetaDataUtil.addDataSourceTableGroups(materials.getDataSourceMap().keySet().iterator().next(), table, dataSourceTableGroups);
        } else {
            tableDataNodes.forEach(dataNode -> TableMetaDataUtil.addDataSourceTableGroups(dataNode.getDataSourceName(), dataNode.getTableName(), dataSourceTableGroups));
        }
    }

    private static void addDataSourceTableGroups(String dataSourceName, String tableName, Map<String, Collection<String>> dataSourceTableGroups) {
        Collection tables = dataSourceTableGroups.getOrDefault(dataSourceName, new LinkedList());
        tables.add(tableName);
        dataSourceTableGroups.putIfAbsent(dataSourceName, tables);
    }

    @Generated
    private TableMetaDataUtil() {
    }
}

