/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rule.identifier.type;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public interface ExportableRule
extends ShardingSphereRule {
    public Map<String, Supplier<Object>> getExportedMethods();

    default public Map<String, Object> export(Collection<String> keys) {
        Map<String, Supplier<Object>> exportMethods = this.getExportedMethods();
        HashMap<String, Object> result = new HashMap<String, Object>(keys.size(), 1.0f);
        keys.forEach(each -> {
            if (exportMethods.containsKey(each)) {
                result.put((String)each, ((Supplier)exportMethods.get(each)).get());
            }
        });
        return result;
    }

    default public Optional<Object> export(String key) {
        Map<String, Supplier<Object>> exportMethods = this.getExportedMethods();
        if (exportMethods.containsKey(key)) {
            return Optional.ofNullable(exportMethods.get(key).get());
        }
        return Optional.empty();
    }

    default public boolean containExportableKey(Collection<String> keys) {
        return keys.stream().anyMatch(each -> this.getExportedMethods().containsKey(each));
    }
}

