/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.ResourceMetaData;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.rule.identifier.type.ResourceHeldRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StaticDataSourceContainedRule;

public final class ShardingSphereMetaData {
    private final Map<String, ShardingSphereDatabase> databases;
    private final ResourceMetaData globalResourceMetaData;
    private final RuleMetaData globalRuleMetaData;
    private final ConfigurationProperties props;
    private final TemporaryConfigurationProperties temporaryProps;

    public ShardingSphereMetaData() {
        this(new HashMap<String, ShardingSphereDatabase>(), new ResourceMetaData(Collections.emptyMap()), new RuleMetaData(Collections.emptyList()), new ConfigurationProperties(new Properties()));
    }

    public ShardingSphereMetaData(Map<String, ShardingSphereDatabase> databases, ResourceMetaData globalResourceMetaData, RuleMetaData globalRuleMetaData, ConfigurationProperties props) {
        this.databases = new ConcurrentHashMap<String, ShardingSphereDatabase>(databases.size(), 1.0f);
        databases.forEach((key, value) -> this.databases.put(key.toLowerCase(), (ShardingSphereDatabase)value));
        this.globalResourceMetaData = globalResourceMetaData;
        this.globalRuleMetaData = globalRuleMetaData;
        this.props = props;
        this.temporaryProps = new TemporaryConfigurationProperties(props.getProps());
    }

    public boolean containsDatabase(String databaseName) {
        return this.databases.containsKey(databaseName.toLowerCase());
    }

    public ShardingSphereDatabase getDatabase(String databaseName) {
        return this.databases.get(databaseName.toLowerCase());
    }

    public void addDatabase(String databaseName, DatabaseType protocolType, ConfigurationProperties props) {
        ShardingSphereDatabase database = ShardingSphereDatabase.create(databaseName, protocolType, props);
        this.databases.put(database.getName().toLowerCase(), database);
        this.globalRuleMetaData.findRules(ResourceHeldRule.class).forEach(each -> each.addResource(database));
    }

    public void dropDatabase(String databaseName) {
        this.closeResources(this.databases.remove(databaseName.toLowerCase()));
    }

    private void closeResources(ShardingSphereDatabase database) {
        String databaseName = database.getName();
        this.globalRuleMetaData.findRules(ResourceHeldRule.class).forEach(each -> each.closeStaleResource(databaseName));
        database.getRuleMetaData().findRules(ResourceHeldRule.class).forEach(each -> each.closeStaleResource(databaseName));
        database.getRuleMetaData().findSingleRule(StaticDataSourceContainedRule.class).ifPresent(StaticDataSourceContainedRule::cleanStorageNodeDataSources);
        Optional.ofNullable(database.getResourceMetaData()).ifPresent(optional -> optional.getStorageUnitMetaData().getStorageUnits().values().forEach(each -> database.getResourceMetaData().close(each.getDataSource())));
    }

    @Generated
    public Map<String, ShardingSphereDatabase> getDatabases() {
        return this.databases;
    }

    @Generated
    public ResourceMetaData getGlobalResourceMetaData() {
        return this.globalResourceMetaData;
    }

    @Generated
    public RuleMetaData getGlobalRuleMetaData() {
        return this.globalRuleMetaData;
    }

    @Generated
    public ConfigurationProperties getProps() {
        return this.props;
    }

    @Generated
    public TemporaryConfigurationProperties getTemporaryProps() {
        return this.temporaryProps;
    }
}

