/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.StorageResourceUtils;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitMetaData;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapper;

public final class ResourceMetaData {
    private final Map<StorageNode, DataSource> dataSourceMap;
    private final StorageUnitMetaData storageUnitMetaData;

    public ResourceMetaData(Map<String, DataSource> dataSources) {
        this(null, dataSources);
    }

    public ResourceMetaData(String databaseName, Map<String, DataSource> dataSources) {
        this.dataSourceMap = StorageResourceUtils.getStorageNodeDataSources(dataSources);
        this.storageUnitMetaData = new StorageUnitMetaData(databaseName, this.dataSourceMap, dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolPropertiesCreator.create((DataSource)((DataSource)entry.getValue())), (oldValue, currentValue) -> oldValue, LinkedHashMap::new)), StorageResourceUtils.getStorageUnitNodeMappers(dataSources));
    }

    public ResourceMetaData(String databaseName, Map<StorageNode, DataSource> dataSourceMap, Map<String, StorageUnitNodeMapper> storageUnitNodeMappers, Map<String, DataSourcePoolProperties> propsMap) {
        this.dataSourceMap = dataSourceMap;
        this.storageUnitMetaData = new StorageUnitMetaData(databaseName, dataSourceMap, propsMap, storageUnitNodeMappers);
    }

    public Collection<String> getAllInstanceDataSourceNames() {
        LinkedList<String> result = new LinkedList<String>();
        for (Map.Entry<String, StorageUnit> entry : this.storageUnitMetaData.getStorageUnits().entrySet()) {
            if (this.isExisted(entry.getKey(), result)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private boolean isExisted(String dataSourceName, Collection<String> existedDataSourceNames) {
        return existedDataSourceNames.stream().anyMatch(each -> this.storageUnitMetaData.getStorageUnits().get(dataSourceName).getConnectionProperties().isInSameDatabaseInstance(this.storageUnitMetaData.getStorageUnits().get(each).getConnectionProperties()));
    }

    public ConnectionProperties getConnectionProperties(String dataSourceName) {
        return this.storageUnitMetaData.getStorageUnits().get(dataSourceName).getConnectionProperties();
    }

    public DatabaseType getStorageType(String dataSourceName) {
        return this.storageUnitMetaData.getStorageUnits().get(dataSourceName).getStorageType();
    }

    public Collection<String> getNotExistedDataSources(Collection<String> resourceNames) {
        return resourceNames.stream().filter(each -> !this.storageUnitMetaData.getStorageUnits().containsKey(each)).collect(Collectors.toSet());
    }

    public void close(DataSource dataSource) {
        new DataSourcePoolDestroyer(dataSource).asyncDestroy();
    }

    @Generated
    public Map<StorageNode, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    @Generated
    public StorageUnitMetaData getStorageUnitMetaData() {
        return this.storageUnitMetaData;
    }
}

